/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.progress;

import java.util.EventObject;
import org.arakhne.afc.progress.Progression;

public class ProgressionEvent
extends EventObject {
    private static final long serialVersionUID = 4840275907048148943L;
    private final boolean isRoot;
    private final int min;
    private final int max;
    private final int value;
    private final double factor;
    private final String comment;
    private final boolean isIndeterminate;

    ProgressionEvent(Progression source, boolean isRoot) {
        super(source);
        this.isRoot = isRoot;
        this.min = source.getMinimum();
        this.max = source.getMaximum();
        this.value = source.getValue();
        this.factor = source.getProgressionFactor();
        this.comment = source.getComment();
        this.isIndeterminate = source.isIndeterminate();
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isFinished() {
        return this.isRoot && this.value >= this.max;
    }

    public Progression getProgression() {
        return (Progression)this.getSource();
    }

    public int getMinimum() {
        return this.min;
    }

    public int getMaximum() {
        return this.max;
    }

    public int getValue() {
        return this.value;
    }

    public double getPercent() {
        return this.factor * 100.0;
    }

    public double getProgressionFactor() {
        return this.factor;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isIndeterminate() {
        return this.isIndeterminate;
    }
}

