/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.progress;

import org.arakhne.afc.progress.Progression;
import org.arakhne.afc.progress.ProgressionEvent;
import org.arakhne.afc.progress.ProgressionListener;
import org.arakhne.afc.progress.SubProgressionModel;
import org.arakhne.afc.util.ListenerCollection;

public class DefaultProgression
implements Progression {
    protected final ListenerCollection<ProgressionListener> listeners = new ListenerCollection();
    private int min;
    private int max;
    private double current;
    private boolean isIndeterminate;
    private boolean isAdjusting;
    private String comment;
    private SubProgressionModel child;

    public DefaultProgression(int value, int min2, int max, boolean adjusting) {
        if (min2 > max) {
            this.min = max;
            this.max = min2;
        } else {
            this.min = min2;
            this.max = max;
        }
        this.current = value < this.min ? this.min : (value > this.max ? this.max : value);
        this.isIndeterminate = false;
        this.isAdjusting = adjusting;
    }

    public DefaultProgression(int value, int min2, int max) {
        this(value, min2, max, false);
    }

    public DefaultProgression(int min2, int max) {
        if (min2 > max) {
            this.min = max;
            this.max = min2;
        } else {
            this.min = min2;
            this.max = max;
        }
        this.current = this.min;
        this.isIndeterminate = true;
        this.isAdjusting = false;
    }

    public DefaultProgression() {
        this.min = 0;
        this.max = 0;
        this.current = this.min;
        this.isIndeterminate = true;
        this.isAdjusting = false;
    }

    @Override
    public void end() {
        int v = this.getValue();
        int m3 = this.getMaximum();
        String comment = this.getComment();
        if (v < m3 || comment != null) {
            this.setValue(m3, null);
        }
        this.fireStateChange();
    }

    @Override
    public void addProgressionListener(ProgressionListener listener) {
        this.listeners.add(ProgressionListener.class, listener);
    }

    @Override
    public void removeProgressionListener(ProgressionListener listener) {
        this.listeners.remove(ProgressionListener.class, listener);
    }

    @Override
    public boolean isRootModel() {
        return true;
    }

    @Override
    public Progression getSuperTask() {
        return null;
    }

    @Override
    public int getTaskDepth() {
        return 0;
    }

    @Override
    public final Progression getSubTask() {
        return this.child;
    }

    @Override
    public final void ensureNoSubTask() {
        if (this.child != null) {
            this.disconnectSubTask(this.child, this.child.getMaxInParent(), false);
        }
    }

    protected void fireStateChange() {
        if (this.listeners != null) {
            ProgressionEvent event = new ProgressionEvent(this, this.isRootModel());
            ProgressionListener[] progressionListenerArray = (ProgressionListener[])this.listeners.getListeners(ProgressionListener.class);
            int n = progressionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProgressionListener listener = progressionListenerArray[n2];
                listener.onProgressionStateChanged(event);
                ++n2;
            }
        }
    }

    protected void fireValueChange() {
        if (this.listeners != null) {
            ProgressionEvent event = new ProgressionEvent(this, this.isRootModel());
            ProgressionListener[] progressionListenerArray = (ProgressionListener[])this.listeners.getListeners(ProgressionListener.class);
            int n = progressionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProgressionListener listener = progressionListenerArray[n2];
                listener.onProgressionValueChanged(event);
                ++n2;
            }
        }
    }

    @Override
    public int getMaximum() {
        return this.max;
    }

    @Override
    public int getMinimum() {
        return this.min;
    }

    @Override
    public double getPercent() {
        int extent = this.max - this.min;
        if ((double)extent == 0.0) {
            return 0.0;
        }
        return (this.current - (double)this.min) * 100.0 / (double)extent;
    }

    @Override
    public double getProgressionFactor() {
        int extent = this.max - this.min;
        if ((double)extent == 0.0) {
            return 0.0;
        }
        return (this.current - (double)this.min) / (double)extent;
    }

    @Override
    public int getValue() {
        return (int)this.current;
    }

    protected double getFloatValue() {
        return this.current;
    }

    @Override
    public boolean isAdjusting() {
        return this.isAdjusting;
    }

    @Override
    public boolean isIndeterminate() {
        return this.isIndeterminate;
    }

    @Override
    public void setIndeterminate(boolean newValue) {
        if (this.isIndeterminate != newValue) {
            this.isIndeterminate = newValue;
            this.fireStateChange();
        }
    }

    @Override
    public void setMaximum(int newMaximum) {
        this.setProperties(this.current, this.min, newMaximum, this.isAdjusting, this.comment, false, false, true, null);
    }

    @Override
    public void setMinimum(int newMinimum) {
        this.setProperties(this.current, newMinimum, this.max, this.isAdjusting, this.comment, false, false, true, null);
    }

    @Override
    public void setProperties(int value, int min2, int max, boolean adjusting, String comment) {
        this.setProperties(value, min2, max, adjusting, comment, true, true, true, this.child);
    }

    @Override
    public void setProperties(int value, int min2, int max, boolean adjusting) {
        this.setProperties(value, min2, max, adjusting, this.comment, false, true, true, this.child);
    }

    private void setProperties(double value, int min2, int max, boolean adjusting, String comment, boolean writeLocalComment, boolean forceDeterminate, boolean forceValue, SubProgressionModel subTask) {
        boolean changed;
        double theValue;
        String uptComment;
        if (this.child != null && this.child != subTask) {
            this.child.disconnect();
        }
        if ((uptComment = comment) != null && "".equals(uptComment)) {
            uptComment = null;
        }
        int theMin = min2;
        int theMax = max;
        if (theMin > max) {
            int tmp = theMin;
            theMin = theMax;
            theMax = tmp;
        }
        if ((theValue = value) < (double)theMin) {
            theValue = theMin;
        }
        if (theValue > (double)theMax) {
            theValue = theMax;
        }
        boolean bl = changed = forceValue && theValue != this.current || !forceValue && theValue > this.current || theMin != this.min || theMax != this.max || adjusting != this.isAdjusting || uptComment != this.comment && (uptComment == null || !uptComment.equals(this.comment));
        if (changed && !adjusting) {
            this.current = theValue;
            this.min = theMin;
            this.max = theMax;
            this.isAdjusting = adjusting;
            if (writeLocalComment) {
                this.comment = uptComment;
            }
            this.fireValueChange();
        }
        if (forceDeterminate) {
            this.setIndeterminate(false);
        }
    }

    @Override
    public void setValue(int newValue) {
        this.setProperties(newValue, this.min, this.max, this.isAdjusting, this.comment, false, true, false, null);
    }

    @Override
    public void setValue(int newValue, String comment) {
        this.setProperties(newValue, this.min, this.max, this.isAdjusting, comment, true, true, false, null);
    }

    void setValue(SubProgressionModel subTask, double newValue, String comment) {
        this.setProperties(newValue, this.min, this.max, this.isAdjusting, comment == null ? this.comment : comment, true, true, false, subTask);
    }

    @Override
    public void setAdjusting(boolean adjusting) {
        this.setProperties(this.current, this.min, this.max, adjusting, this.comment, false, false, false, null);
    }

    @Override
    public final Progression subTask(int extent, int minValue, int maxValue) {
        return this.subTask(extent, minValue, maxValue, false);
    }

    @Override
    public Progression subTask(int extent, int minValue, int maxValue, boolean overwriteComment) {
        if (this.child != null) {
            this.child.disconnect();
        }
        this.child = new SubProgressionModel(this, this.current, this.current + (double)Math.abs(extent), minValue, maxValue, this.isIndeterminate, this.isAdjusting, overwriteComment);
        return this.child;
    }

    @Override
    public final Progression subTask(int extent) {
        return this.subTask(extent, false);
    }

    @Override
    public Progression subTask(int extent, boolean overwriteComment) {
        if (this.child != null) {
            this.child.disconnect();
        }
        this.child = new SubProgressionModel(this, this.current, this.current + (double)Math.abs(extent), this.isIndeterminate, this.isAdjusting, overwriteComment);
        return this.child;
    }

    void disconnectSubTask(SubProgressionModel subTask, double value, boolean overwriteComment) {
        if (this.child == subTask) {
            String cmt;
            if (overwriteComment && (cmt = subTask.getComment()) != null) {
                this.comment = cmt;
            }
            this.child = null;
            this.setProperties(value, this.min, this.max, this.isAdjusting, this.comment, overwriteComment, true, false, null);
        }
    }

    @Override
    public String getComment() {
        String childComment;
        if (this.child != null && (childComment = this.child.getComment()) != null) {
            return childComment;
        }
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.setProperties(this.current, this.min, this.max, this.isAdjusting, comment, true, true, false, null);
    }

    @Override
    public void increment(int amount) {
        this.setProperties((int)this.current + amount, this.min, this.max, this.isAdjusting, this.comment, false, true, false, null);
    }

    @Override
    public void increment(int amount, String comment) {
        this.setProperties((int)this.current + amount, this.min, this.max, this.isAdjusting, comment, true, true, false, null);
    }

    @Override
    public void increment() {
        this.setProperties((int)this.current + 1, this.min, this.max, this.isAdjusting, this.comment, false, true, false, null);
    }

    @Override
    public void increment(String comment) {
        this.setProperties((int)this.current + 1, this.min, this.max, this.isAdjusting, comment, true, true, false, null);
    }
}

