/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.util.concurrent;

import com.google.common.base.Objects;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.lang.util.SynchronizedIterable;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.util.concurrent.Collections3;
import io.sarl.util.concurrent.Collections3$SynchronizedCollectionWrapper$1$AssertEvaluator$;
import io.sarl.util.concurrent.Collections3$UnmodifiableSynchronizedIterableWrapper$1$AssertEvaluator$;
import io.sarl.util.concurrent.NoReadWriteLock;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.10")
@SarlElementType(value=10)
public final class Collections3 {
    public static final SynchronizedSet<Object> EMPTY_SET = new EmptySet();

    private Collections3() {
    }

    @Pure
    public static <T> SynchronizedSet<T> synchronizedSet(Set<T> set, ReadWriteLock lock) {
        return new SynchronizedSetWrapper<T>(set, lock);
    }

    @Pure
    public static <T> SynchronizedCollection<T> synchronizedCollection(Collection<T> collection, ReadWriteLock lock) {
        return new SynchronizedCollectionWrapper<T>(collection, lock);
    }

    @Pure
    public static <T> SynchronizedSet<T> emptySynchronizedSet() {
        return EMPTY_SET;
    }

    @Pure
    public static <T> SynchronizedSet<T> synchronizedSingleton(T element) {
        return new SingletonSet<T>(element);
    }

    @Pure
    public static <T> SynchronizedSet<T> unmodifiableSynchronizedSet(SynchronizedSet<T> elements) {
        return new UnmodifiableSetWrapper<T>(elements);
    }

    @Pure
    public static <T> SynchronizedSet<T> unmodifiableSynchronizedSet(Set<T> elements, ReadWriteLock lock) {
        return new UnmodifiableSynchronizedSetWrapper<T>(elements, lock);
    }

    @Pure
    public static <T> SynchronizedIterable<T> unmodifiableSynchronizedIterable(Iterable<T> elements, ReadWriteLock lock) {
        return new UnmodifiableSynchronizedIterableWrapper<T>(elements, lock);
    }

    @Pure
    public static <T> Collection<T> serializableCollection(Collection<T> elements) {
        if (elements instanceof Serializable) {
            return elements;
        }
        return new SerializableCollectionWrapper<T>(elements);
    }

    @Pure
    public static <T> SynchronizedCollection<T> unmodifiableSynchronizedCollection(Collection<T> elements, ReadWriteLock lock) {
        return new UnmodifiableSynchronizedCollectionWrapper<T>(elements, lock);
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class EmptySet
    extends AbstractSet<Object>
    implements SynchronizedSet<Object>,
    Serializable {
        @SyntheticMember
        private static final long serialVersionUID = 390134042L;

        EmptySet() {
        }

        @Override
        @Pure
        public ReadWriteLock getLock() {
            return NoReadWriteLock.SINGLETON;
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        private void writeObject(ObjectOutputStream stream) {
            try {
                stream.defaultWriteObject();
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow(_e);
            }
        }

        private void readObject(ObjectInputStream stream) {
            try {
                stream.defaultReadObject();
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow(_e);
            }
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class SerializableCollectionWrapper<E>
    extends AbstractCollection<E>
    implements Serializable {
        private transient Collection<E> collection;
        @SyntheticMember
        private static final long serialVersionUID = -4271460539L;

        SerializableCollectionWrapper(Collection<E> collection) {
            this.collection = collection;
        }

        @Override
        public Iterator<E> iterator() {
            return this.collection.iterator();
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        private void writeObject(ObjectOutputStream stream) {
            try {
                stream.defaultWriteObject();
                stream.writeInt(this.collection.size());
                for (E element : this.collection) {
                    stream.writeObject(element);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow(_e);
            }
        }

        private void readObject(ObjectInputStream stream) {
            try {
                stream.defaultReadObject();
                int s2 = stream.readInt();
                ArrayList _arrayList = new ArrayList(s2);
                this.collection = _arrayList;
                int i = 0;
                while (i < s2) {
                    Object _readObject = stream.readObject();
                    this.collection.add(_readObject);
                    ++i;
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow(_e);
            }
        }

        @Override
        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class SingletonSet<T>
    extends AbstractSet<T>
    implements SynchronizedSet<T>,
    Serializable {
        private final T singleton;
        @SyntheticMember
        private static final long serialVersionUID = -1422237643L;

        SingletonSet(T singleton) {
            this.singleton = singleton;
        }

        @Override
        @Pure
        public ReadWriteLock getLock() {
            return NoReadWriteLock.SINGLETON;
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.singleton(this.singleton).iterator();
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class SynchronizedCollectionWrapper<E>
    implements Serializable,
    SynchronizedCollection<E> {
        final Collection<E> collection;
        transient ReadWriteLock lock;
        @SyntheticMember
        private static final long serialVersionUID = 115165052L;

        public SynchronizedCollectionWrapper(Collection<E> collection, ReadWriteLock lock) {
            assert (new Collections3$SynchronizedCollectionWrapper$1$AssertEvaluator$((SynchronizedCollectionWrapper)this, collection).$$result);
            class _1 {
                final boolean $$result;
                final /* synthetic */ SynchronizedCollectionWrapper this$1;

                _1(SynchronizedCollectionWrapper synchronizedCollectionWrapper, ReadWriteLock readWriteLock) {
                    this.this$1 = synchronizedCollectionWrapper;
                    this.$$result = readWriteLock != null;
                }
            }
            assert (new _1((SynchronizedCollectionWrapper)this, (ReadWriteLock)lock).$$result);
            this.collection = collection;
            this.lock = lock;
        }

        @Override
        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            this.lock.readLock().lock();
            try {
                boolean bl = Objects.equal(this.collection, obj);
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        @Pure
        public int hashCode() {
            this.lock.readLock().lock();
            try {
                int n = this.collection.hashCode();
                return n;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public int size() {
            this.lock.readLock().lock();
            try {
                int n = this.collection.size();
                return n;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public boolean isEmpty() {
            this.lock.readLock().lock();
            try {
                boolean bl = this.collection.isEmpty();
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public boolean contains(Object object) {
            this.lock.readLock().lock();
            try {
                boolean bl = this.collection.contains(object);
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public Object[] toArray() {
            this.lock.readLock().lock();
            try {
                Object[] objectArray = this.collection.toArray();
                return objectArray;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public <T> T[] toArray(T[] output) {
            this.lock.readLock().lock();
            try {
                T[] TArray = this.collection.toArray(output);
                return TArray;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.collection.iterator();
        }

        @Override
        public boolean add(E element) {
            this.lock.writeLock().lock();
            try {
                boolean bl = this.collection.add(element);
                return bl;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        public boolean remove(Object element) {
            this.lock.writeLock().lock();
            try {
                boolean bl = this.collection.remove(element);
                return bl;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        @Pure
        public boolean containsAll(Collection<?> coll) {
            this.lock.readLock().lock();
            try {
                boolean bl = this.collection.containsAll(coll);
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public boolean addAll(Collection<? extends E> coll) {
            this.lock.writeLock().lock();
            try {
                boolean bl = this.collection.addAll(coll);
                return bl;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            this.lock.writeLock().lock();
            try {
                boolean bl = this.collection.removeAll(coll);
                return bl;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            this.lock.writeLock().lock();
            try {
                boolean bl = this.collection.retainAll(coll);
                return bl;
            }
            finally {
                this.lock.writeLock().lock();
            }
        }

        @Override
        public void clear() {
            this.lock.writeLock().lock();
            try {
                this.collection.clear();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Pure
        public String toString() {
            this.lock.readLock().lock();
            try {
                String string = this.collection.toString();
                return string;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private void writeObject(ObjectOutputStream stream) {
            try {
                this.lock.readLock().lock();
                try {
                    stream.defaultWriteObject();
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow(_e);
            }
        }

        private void readObject(ObjectInputStream stream) {
            try {
                this.lock.writeLock().lock();
                try {
                    stream.defaultReadObject();
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow(_e);
            }
        }

        @Override
        @Pure
        public ReadWriteLock getLock() {
            return this.lock;
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class SynchronizedSetWrapper<E>
    extends SynchronizedCollectionWrapper<E>
    implements SynchronizedSet<E> {
        @SyntheticMember
        private static final long serialVersionUID = 1832174162L;

        SynchronizedSetWrapper(Set<E> set, ReadWriteLock lock) {
            super(set, lock);
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class UnmodifiableIterator<E>
    implements Iterator<E> {
        private final Iterator<E> iterator;

        UnmodifiableIterator(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class UnmodifiableSetWrapper<E>
    implements Serializable,
    SynchronizedSet<E> {
        private final SynchronizedSet<E> collection;
        @SyntheticMember
        private static final long serialVersionUID = -2098701599L;

        UnmodifiableSetWrapper(SynchronizedSet<E> set) {
            this.collection = set;
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.collection.contains(object);
        }

        @Override
        public Iterator<E> iterator() {
            Iterator _iterator = this.collection.iterator();
            return new UnmodifiableIterator(_iterator);
        }

        @Override
        public Object[] toArray() {
            return this.collection.toArray();
        }

        @Override
        public <T> T[] toArray(T[] output) {
            return this.collection.toArray(output);
        }

        @Override
        public boolean add(E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object element) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Pure
        public boolean containsAll(Collection<?> collection) {
            return this.collection.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Pure
        public ReadWriteLock getLock() {
            return this.collection.getLock();
        }

        @Override
        public Spliterator<E> spliterator() {
            return Spliterators.spliterator(this, 1);
        }

        @Override
        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class UnmodifiableSynchronizedCollectionWrapper<E>
    extends SynchronizedCollectionWrapper<E> {
        @SyntheticMember
        private static final long serialVersionUID = -1221809584L;

        UnmodifiableSynchronizedCollectionWrapper(Collection<E> set, ReadWriteLock lock) {
            super(set, lock);
        }

        @Override
        public boolean add(E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            Iterator _iterator = super.iterator();
            return new UnmodifiableIterator(_iterator);
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class UnmodifiableSynchronizedIterableWrapper<E>
    implements SynchronizedIterable<E> {
        private final Iterable<E> iterable;
        private transient ReadWriteLock lock;

        UnmodifiableSynchronizedIterableWrapper(Iterable<E> iterable, ReadWriteLock lock) {
            assert (new Collections3$UnmodifiableSynchronizedIterableWrapper$1$AssertEvaluator$((UnmodifiableSynchronizedIterableWrapper)this, iterable).$$result);
            class _1 {
                final boolean $$result;
                final /* synthetic */ UnmodifiableSynchronizedIterableWrapper this$1;

                _1(UnmodifiableSynchronizedIterableWrapper unmodifiableSynchronizedIterableWrapper, ReadWriteLock readWriteLock) {
                    this.this$1 = unmodifiableSynchronizedIterableWrapper;
                    this.$$result = readWriteLock != null;
                }
            }
            assert (new _1((UnmodifiableSynchronizedIterableWrapper)this, (ReadWriteLock)lock).$$result);
            this.iterable = iterable;
            this.lock = lock;
        }

        @Override
        public Iterator<E> iterator() {
            Iterator<E> _iterator = this.iterable.iterator();
            return new UnmodifiableIterator<E>(_iterator);
        }

        @Override
        @Pure
        public ReadWriteLock getLock() {
            if (this.lock == null) {
                ReentrantReadWriteLock _reentrantReadWriteLock = new ReentrantReadWriteLock();
                this.lock = _reentrantReadWriteLock;
            }
            return this.lock;
        }

        private void writeObject(ObjectOutputStream stream) {
            try {
                this.lock.readLock().lock();
                try {
                    stream.defaultWriteObject();
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow(_e);
            }
        }

        private void readObject(ObjectInputStream stream) {
            try {
                this.getLock().writeLock().lock();
                try {
                    stream.defaultReadObject();
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow(_e);
            }
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class UnmodifiableSynchronizedSetWrapper<E>
    extends SynchronizedSetWrapper<E> {
        UnmodifiableSynchronizedSetWrapper(Set<E> set, ReadWriteLock lock) {
            super(set, lock);
        }

        @Override
        public boolean add(E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Pure
        public Iterator<E> iterator() {
            Iterator _iterator = super.iterator();
            return new UnmodifiableIterator(_iterator);
        }
    }
}

