/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.util;

import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Scope;
import io.sarl.util.AddressScope;
import io.sarl.util.IdentifierScope;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Pure;

@Deprecated
@SarlSpecification(value="0.10")
@SarlElementType(value=10)
public final class Scopes {
    private static final Scope<?> ALL = new AlwaysTrueScope();

    private Scopes() {
    }

    @Pure
    public static <T> Scope<T> allParticipants() {
        return ALL;
    }

    @Pure
    public static Scope<Address> addresses(Address ... addresses) {
        return new AddressScope(addresses);
    }

    @Pure
    public static Scope<Address> notAddresses(Address ... addresses) {
        return Scopes.not(Scopes.addresses(addresses));
    }

    @Pure
    public static Scope<Address> identifiers(UUID ... identifiers) {
        return new IdentifierScope(identifiers);
    }

    @Pure
    public static Scope<Address> notIdentifiers(UUID ... identifiers) {
        return Scopes.not(Scopes.identifiers(identifiers));
    }

    @Pure
    public static Scope<Address> not(Scope<Address> scope) {
        return new NotScope<Address>(scope);
    }

    @Pure
    public static Scope<Address> or(Scope<Address> scope1, Scope<Address> scope2) {
        return new OrScope<Address>(scope1, scope2);
    }

    @Pure
    public static Scope<Address> and(Scope<Address> scope1, Scope<Address> scope2) {
        return new AndScope<Address>(scope1, scope2);
    }

    @Pure
    public static Scope<Address> xor(Scope<Address> scope1, Scope<Address> scope2) {
        return new XorScope<Address>(scope1, scope2);
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class AlwaysTrueScope
    implements Scope<Object> {
        @SyntheticMember
        private static final long serialVersionUID = -332632675L;

        @Pure
        public String toString() {
            return "AlwaysTRUE";
        }

        @Override
        @Pure
        public boolean matches(Object element) {
            return true;
        }

        @SyntheticMember
        public AlwaysTrueScope() {
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class AndScope<T>
    implements Scope<T> {
        private final Scope<T>[] scopes;
        @SyntheticMember
        private static final long serialVersionUID = 1896010764L;

        @SafeVarargs
        public AndScope(Scope<T> ... scopes) {
            this.scopes = scopes;
        }

        @Pure
        public String toString() {
            String _xblockexpression = null;
            StringBuilder buffer = new StringBuilder();
            int len = this.scopes.length;
            if (len > 0) {
                buffer.append(this.scopes[0]);
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(1, len, true);
                for (Integer i : _doubleDotLessThan) {
                    buffer.append(" && ");
                    buffer.append(this.scopes[i == null ? 0 : i]);
                }
            }
            _xblockexpression = buffer.toString();
            return _xblockexpression;
        }

        @Override
        @Pure
        public boolean matches(T element) {
            Scope<T>[] scopeArray = this.scopes;
            int n = this.scopes.length;
            int n2 = 0;
            while (n2 < n) {
                Scope<T> scope = scopeArray[n2];
                boolean _matches = scope.matches(element);
                if (!_matches) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class NotScope<T>
    implements Scope<T> {
        private final Scope<T> scope;
        @SyntheticMember
        private static final long serialVersionUID = -106786425L;

        public NotScope(Scope<T> scope) {
            this.scope = scope;
        }

        @Pure
        public String toString() {
            String _string = this.scope.toString();
            return "! " + _string;
        }

        @Override
        @Pure
        public boolean matches(T element) {
            boolean _matches = this.scope.matches(element);
            return !_matches;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class OrScope<T>
    implements Scope<T> {
        private final Scope<T>[] scopes;
        @SyntheticMember
        private static final long serialVersionUID = 1896010764L;

        @SafeVarargs
        public OrScope(Scope<T> ... scopes) {
            this.scopes = scopes;
        }

        @Pure
        public String toString() {
            String _xblockexpression = null;
            StringBuilder buffer = new StringBuilder();
            int len = this.scopes.length;
            if (len > 0) {
                buffer.append(this.scopes[0]);
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(1, len, true);
                for (Integer i : _doubleDotLessThan) {
                    buffer.append(" || ");
                    buffer.append(this.scopes[i == null ? 0 : i]);
                }
            }
            _xblockexpression = buffer.toString();
            return _xblockexpression;
        }

        @Override
        @Pure
        public boolean matches(T element) {
            Scope<T>[] scopeArray = this.scopes;
            int n = this.scopes.length;
            int n2 = 0;
            while (n2 < n) {
                Scope<T> scope = scopeArray[n2];
                boolean _matches = scope.matches(element);
                if (_matches) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class XorScope<T>
    implements Scope<T> {
        private final Scope<T>[] scopes;
        @SyntheticMember
        private static final long serialVersionUID = 1896010764L;

        @SafeVarargs
        public XorScope(Scope<T> ... scopes) {
            this.scopes = scopes;
        }

        @Pure
        public String toString() {
            String _xblockexpression = null;
            StringBuilder buffer = new StringBuilder();
            int len = this.scopes.length;
            if (len > 0) {
                buffer.append(this.scopes[0]);
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(1, len, true);
                for (Integer i : _doubleDotLessThan) {
                    buffer.append(" ^ ");
                    buffer.append(this.scopes[i == null ? 0 : i]);
                }
            }
            _xblockexpression = buffer.toString();
            return _xblockexpression;
        }

        @Override
        @Pure
        public boolean matches(T element) {
            boolean _xblockexpression = false;
            boolean active = false;
            Scope<T>[] scopeArray = this.scopes;
            int n = this.scopes.length;
            int n2 = 0;
            while (n2 < n) {
                Scope<T> scope = scopeArray[n2];
                boolean _matches = scope.matches(element);
                if (_matches) {
                    if (active) {
                        return false;
                    }
                    active = true;
                }
                ++n2;
            }
            _xblockexpression = active;
            return _xblockexpression;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }
}

