/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.util;

import java.io.InvalidClassException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.WriteAbortedException;
import java.lang.reflect.Constructor;

public class SerializableProxy
implements Serializable {
    private static final long serialVersionUID = -2601677585237973795L;
    private final Class<?> proxyType;
    private final Object[] values;

    public SerializableProxy(Class<?> type, Object ... values) {
        assert (type.isLocalClass() || type.isAnonymousClass());
        this.proxyType = type;
        this.values = values;
    }

    public <T> T getValue(int index) {
        return (T)this.values[index];
    }

    private Object readResolve() throws ObjectStreamException {
        Constructor<?> compatible = null;
        Constructor<?>[] constructorArray = this.proxyType.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> candidate = constructorArray[n2];
            if (candidate != null && this.isCompatible(candidate)) {
                if (compatible != null) {
                    throw new IllegalStateException();
                }
                compatible = candidate;
            }
            ++n2;
        }
        if (compatible != null) {
            if (!compatible.isAccessible()) {
                compatible.setAccessible(true);
            }
            try {
                Object[] arguments = new Object[this.values.length + 1];
                System.arraycopy(this.values, 0, arguments, 1, this.values.length);
                return compatible.newInstance(arguments);
            }
            catch (Exception exception) {
                throw new WriteAbortedException(exception.getLocalizedMessage(), exception);
            }
        }
        throw new InvalidClassException("compatible constructor not found");
    }

    private boolean isCompatible(Constructor<?> candidate) throws ObjectStreamException {
        Class<?>[] parameterTypes = candidate.getParameterTypes();
        if (parameterTypes.length != this.values.length + 1) {
            return false;
        }
        Class<?> enclosingType = this.proxyType.getEnclosingClass();
        if (!parameterTypes[0].isAssignableFrom(enclosingType)) {
            return false;
        }
        int i = 0;
        int j = 1;
        while (i < this.values.length) {
            Object param = this.values[i];
            assert (j < parameterTypes.length);
            Class<?> clazz = parameterTypes[j];
            if (clazz.isPrimitive()) {
                clazz = SerializableProxy.wrapperTypeFor(clazz);
            }
            if (param != null && !clazz.isInstance(param)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private static Class<?> wrapperTypeFor(Class<?> primitive) throws ObjectStreamException {
        if (primitive == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitive == Byte.TYPE) {
            return Byte.class;
        }
        if (primitive == Character.TYPE) {
            return Character.class;
        }
        if (primitive == Short.TYPE) {
            return Short.class;
        }
        if (primitive == Integer.TYPE) {
            return Integer.class;
        }
        if (primitive == Long.TYPE) {
            return Long.class;
        }
        if (primitive == Float.TYPE) {
            return Float.class;
        }
        if (primitive == Double.TYPE) {
            return Double.class;
        }
        if (primitive == Void.TYPE) {
            return Void.class;
        }
        throw new StreamCorruptedException();
    }
}

