/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.scoping.extensions.numbers.comparison;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class PrimitiveByteComparisonExtensions {
    private PrimitiveByteComparisonExtensions() {
    }

    @Pure
    @Inline(value="($1 >= $2.doubleValue())", constantExpression=true)
    public static boolean operator_greaterEqualsThan(byte left, Number right) {
        return (double)left >= right.doubleValue();
    }

    @Pure
    @Inline(value="($1 <= $2.doubleValue())", constantExpression=true)
    public static boolean operator_lessEqualsThan(byte left, Number right) {
        return (double)left <= right.doubleValue();
    }

    @Pure
    @Inline(value="($1 > $2.doubleValue())", constantExpression=true)
    public static boolean operator_greaterThan(byte left, Number right) {
        return (double)left > right.doubleValue();
    }

    @Pure
    @Inline(value="($1 < $2.doubleValue())", constantExpression=true)
    public static boolean operator_lessThan(byte left, Number right) {
        return (double)left < right.doubleValue();
    }

    @Pure
    @Inline(value="($2 != null && $1 == $2.doubleValue())", constantExpression=true)
    public static boolean operator_equals(byte left, Number right) {
        return right != null && (double)left == right.doubleValue();
    }

    @Pure
    @Inline(value="($2 == null || $1 != $2.doubleValue())", constantExpression=true)
    public static boolean operator_notEquals(byte left, Number right) {
        return right == null || (double)left != right.doubleValue();
    }

    @Pure
    @Inline(value="$3.compare($1, $2)", constantExpression=true, imported={Byte.class})
    public static int operator_spaceship(byte left, byte right) {
        return Byte.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2)", constantExpression=true, imported={Short.class})
    public static int operator_spaceship(byte left, short right) {
        return Short.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2)", constantExpression=true, imported={Integer.class})
    public static int operator_spaceship(byte left, int right) {
        return Integer.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2)", constantExpression=true, imported={Long.class})
    public static int operator_spaceship(byte left, long right) {
        return Long.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2)", constantExpression=true, imported={Float.class})
    public static int operator_spaceship(byte left, float right) {
        return Float.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2)", constantExpression=true, imported={Double.class})
    public static int operator_spaceship(byte left, double right) {
        return Double.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2.byteValue())", constantExpression=true, imported={Byte.class})
    public static int operator_spaceship(byte left, Byte right) {
        return Byte.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2.shortValue())", constantExpression=true, imported={Short.class})
    public static int operator_spaceship(byte left, Short right) {
        return Short.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2.intValue())", constantExpression=true, imported={Integer.class})
    public static int operator_spaceship(byte left, Integer right) {
        return Integer.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2.longValue())", constantExpression=true, imported={Long.class})
    public static int operator_spaceship(byte left, Long right) {
        return Long.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2.floatValue())", constantExpression=true, imported={Float.class})
    public static int operator_spaceship(byte left, Float right) {
        return Float.compare(left, right.floatValue());
    }

    @Pure
    @Inline(value="$3.compare($1, $2.doubleValue())", constantExpression=true, imported={Double.class})
    public static int operator_spaceship(byte left, Double right) {
        return Double.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2.intValue())", constantExpression=true, imported={Integer.class})
    public static int operator_spaceship(byte left, AtomicInteger right) {
        return Integer.compare(left, right.intValue());
    }

    @Pure
    @Inline(value="$3.compare($1, $2.longValue())", constantExpression=true, imported={Long.class})
    public static int operator_spaceship(byte left, AtomicLong right) {
        return Long.compare(left, right.longValue());
    }

    @Pure
    @Inline(value="$3.compare($1, $2.doubleValue())", constantExpression=true, imported={Double.class})
    public static int operator_spaceship(byte left, Number right) {
        return Double.compare(left, right.doubleValue());
    }
}

