/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.scoping.extensions.numbers.cast;

import com.google.common.util.concurrent.AtomicDouble;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class PrimitiveLongCastExtensions {
    private PrimitiveLongCastExtensions() {
    }

    @Pure
    @Inline(value="$2.toString($1)", imported={Long.class})
    public static String toString(long number) {
        return Long.toString(number);
    }

    @Pure
    @Inline(value="new $2($1)", imported={AtomicLong.class})
    public static AtomicLong toAtomicLong(long number) {
        return new AtomicLong(number);
    }

    @Pure
    @Inline(value="new $2(($3) $1)", imported={AtomicInteger.class, int.class})
    public static AtomicInteger toAtomicInteger(long number) {
        return new AtomicInteger((int)number);
    }

    @Pure
    @Inline(value="new $2($1)", imported={AtomicDouble.class})
    public static AtomicDouble toAtomicDouble(long number) {
        return new AtomicDouble(number);
    }

    @Pure
    @Inline(value="$2.valueOf($1)", imported={BigInteger.class})
    public static BigInteger toBigInteger(long number) {
        return BigInteger.valueOf(number);
    }

    @Pure
    @Inline(value="$2.valueOf($1)", imported={BigDecimal.class})
    public static BigDecimal toBigDecimal(long number) {
        return BigDecimal.valueOf(number);
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={Byte.class, byte.class})
    public static Byte toByte(long number) {
        return (byte)number;
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={Short.class, short.class})
    public static Short toShort(long number) {
        return (short)number;
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={Integer.class, int.class})
    public static Integer toInteger(long number) {
        return (int)number;
    }

    @Pure
    @Inline(value="$2.valueOf($1)", imported={Float.class})
    public static Float toFloat(long number) {
        return Float.valueOf(number);
    }

    @Pure
    @Inline(value="$2.valueOf($1)", imported={Double.class})
    public static Double toDouble(long number) {
        return number;
    }
}

