/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.scoping.extensions.numbers.cast;

import com.google.common.util.concurrent.AtomicDouble;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class PrimitiveDoubleCastExtensions {
    private PrimitiveDoubleCastExtensions() {
    }

    @Pure
    @Inline(value="$2.toString($1)", imported={Double.class})
    public static String toString(double number) {
        return Double.toString(number);
    }

    @Pure
    @Inline(value="new $2(($3) $1)", imported={AtomicLong.class, long.class})
    public static AtomicLong toAtomicLong(double number) {
        return new AtomicLong((long)number);
    }

    @Pure
    @Inline(value="new $2(($3) $1)", imported={AtomicInteger.class, int.class})
    public static AtomicInteger toAtomicInteger(double number) {
        return new AtomicInteger((int)number);
    }

    @Pure
    @Inline(value="new $2($1)", imported={AtomicDouble.class})
    public static AtomicDouble toAtomicDouble(double number) {
        return new AtomicDouble(number);
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={BigInteger.class, long.class})
    public static BigInteger toBigInteger(double number) {
        return BigInteger.valueOf((long)number);
    }

    @Pure
    @Inline(value="$2.valueOf($1)", imported={BigDecimal.class})
    public static BigDecimal toBigDecimal(double number) {
        return BigDecimal.valueOf(number);
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={Byte.class, byte.class})
    public static Byte toByte(double number) {
        return (byte)number;
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={Short.class, short.class})
    public static Short toShort(double number) {
        return (short)number;
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={Integer.class, int.class})
    public static Integer toInteger(double number) {
        return (int)number;
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={Long.class, long.class})
    public static Long toLong(double number) {
        return (long)number;
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={Float.class, float.class})
    public static Float toFloat(double number) {
        return Float.valueOf((float)number);
    }
}

