/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.scoping.extensions.numbers.cast;

import com.google.common.util.concurrent.AtomicDouble;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class NumberCastExtensions {
    private NumberCastExtensions() {
    }

    @Pure
    @Inline(value="$2.valueOf($1.byteValue())", imported={Byte.class})
    public static Byte toByte(Number number) {
        return number.byteValue();
    }

    @Pure
    @Inline(value="$2.valueOf($1.shortValue())", imported={Short.class})
    public static Short toShort(Number number) {
        return number.shortValue();
    }

    @Pure
    @Inline(value="$2.valueOf($1.intValue())", imported={Integer.class})
    public static Integer toInteger(Number number) {
        return number.intValue();
    }

    @Pure
    @Inline(value="new $2($1.intValue())", imported={AtomicInteger.class})
    public static AtomicInteger toAtomicInteger(Number number) {
        return new AtomicInteger(number.intValue());
    }

    @Pure
    @Inline(value="$2.valueOf($1.longValue())", imported={Long.class})
    public static Long toLong(Number number) {
        return number.longValue();
    }

    @Pure
    @Inline(value="new $2($1.longValue())", imported={AtomicLong.class})
    public static AtomicLong toAtomicLong(Number number) {
        return new AtomicLong(number.longValue());
    }

    @Pure
    @Inline(value="$2.valueOf($1.floatValue())", imported={Float.class})
    public static Float toFloat(Number number) {
        return Float.valueOf(number.longValue());
    }

    @Pure
    @Inline(value="$2.valueOf($1.doubleValue())", imported={Double.class})
    public static Double toDouble(Number number) {
        return number.doubleValue();
    }

    @Pure
    @Inline(value="new $2($1.doubleValue())", imported={AtomicDouble.class})
    public static AtomicDouble toAtomicDouble(Number number) {
        return new AtomicDouble(number.doubleValue());
    }

    @Pure
    @Inline(value="$2.valueOf($1.longValue())", imported={BigInteger.class})
    public static BigInteger toBigInteger(Number number) {
        return BigInteger.valueOf(number.longValue());
    }

    @Pure
    @Inline(value="$2.valueOf($1.doubleValue())", imported={BigDecimal.class})
    public static BigDecimal toBigDecimal(Number number) {
        return BigDecimal.valueOf(number.doubleValue());
    }
}

