/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.scoping.extensions.numbers.cast;

import com.google.common.util.concurrent.AtomicDouble;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class AtomicIntegerCastExtensions {
    private AtomicIntegerCastExtensions() {
    }

    @Pure
    @Inline(value="$2.valueOf($1.byteValue())", imported={Byte.class})
    public static Byte toByte(AtomicInteger number) {
        return number.byteValue();
    }

    @Pure
    @Inline(value="$2.valueOf($1.shortValue())", imported={Short.class})
    public static Short toShort(AtomicInteger number) {
        return number.shortValue();
    }

    @Pure
    @Inline(value="$2.valueOf($1.intValue())", imported={Integer.class})
    public static Integer toInteger(AtomicInteger number) {
        return number.intValue();
    }

    @Pure
    @Inline(value="$2.valueOf($1.longValue())", imported={Long.class})
    public static Long toLong(AtomicInteger number) {
        return number.longValue();
    }

    @Pure
    @Inline(value="new $2($1.longValue())", imported={AtomicLong.class})
    public static AtomicLong toAtomicLong(AtomicInteger number) {
        return new AtomicLong(number.longValue());
    }

    @Pure
    @Inline(value="$2.valueOf($1.floatValue())", imported={Float.class})
    public static Float toFloat(AtomicInteger number) {
        return Float.valueOf(number.floatValue());
    }

    @Pure
    @Inline(value="$2.valueOf($1.doubleValue())", imported={Double.class})
    public static Double toDouble(AtomicInteger number) {
        return number.doubleValue();
    }

    @Pure
    @Inline(value="new $2($1.doubleValue())", imported={AtomicDouble.class})
    public static AtomicDouble toAtomicDouble(AtomicInteger number) {
        return new AtomicDouble(number.doubleValue());
    }

    @Pure
    @Inline(value="$2.valueOf($1.longValue())", imported={BigInteger.class})
    public static BigInteger toBigInteger(AtomicInteger number) {
        return BigInteger.valueOf(number.longValue());
    }

    @Pure
    @Inline(value="$2.valueOf($1.doubleValue())", imported={BigDecimal.class})
    public static BigDecimal toBigDecimal(AtomicInteger number) {
        return BigDecimal.valueOf(number.doubleValue());
    }
}

