/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.scoping.extensions.cast;

import com.google.common.util.concurrent.AtomicDouble;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class PrimitiveCastExtensions {
    private PrimitiveCastExtensions() {
    }

    @Pure
    @Inline(value="$2.parseBoolean(($1).toString())", imported={Boolean.class})
    public static boolean booleanValue(CharSequence value) {
        return value != null && Boolean.parseBoolean(value.toString());
    }

    @Pure
    @Inline(value="$2.toString($1)", imported={Boolean.class})
    public static String toString(boolean value) {
        return Boolean.toString(value);
    }

    @Pure
    @Inline(value="$2.toString($1)", imported={Character.class})
    public static String toString(char value) {
        return Character.toString(value);
    }

    @Pure
    public static byte byteValue(CharSequence value) {
        try {
            return Byte.decode(value.toString());
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    @Pure
    public static short shortValue(CharSequence value) {
        try {
            return Short.decode(value.toString());
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    @Pure
    public static int intValue(CharSequence value) {
        try {
            return Integer.decode(value.toString());
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    @Pure
    public static long longValue(CharSequence value) {
        try {
            return Long.decode(value.toString());
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    @Pure
    public static float floatValue(CharSequence value) {
        try {
            return Float.parseFloat(value.toString());
        }
        catch (Throwable throwable) {
            return 0.0f;
        }
    }

    @Pure
    public static double doubleValue(CharSequence value) {
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Throwable throwable) {
            return 0.0;
        }
    }

    @Pure
    @Inline(value="new $2($3.intValue($1))", imported={AtomicInteger.class, PrimitiveCastExtensions.class})
    public static AtomicInteger toAtomicInteger(CharSequence value) {
        return new AtomicInteger(PrimitiveCastExtensions.intValue(value));
    }

    @Pure
    @Inline(value="new $2($3.longValue($1))", imported={AtomicLong.class, PrimitiveCastExtensions.class})
    public static AtomicLong toAtomicLong(CharSequence value) {
        return new AtomicLong(PrimitiveCastExtensions.longValue(value));
    }

    @Pure
    @Inline(value="new $2($3.doubleValue($1))", imported={AtomicDouble.class, PrimitiveCastExtensions.class})
    public static AtomicDouble toAtomicDouble(CharSequence value) {
        return new AtomicDouble(PrimitiveCastExtensions.doubleValue(value));
    }

    private static boolean startsWith(CharSequence value, String prefix, int index) {
        if (value == null) {
            return prefix == null;
        }
        int prefixLength = prefix.length();
        if (value.length() == 0) {
            return prefixLength == 0;
        }
        int eoffset = index + prefixLength;
        if (eoffset > value.length()) {
            return false;
        }
        int idx0 = index;
        int idx1 = 0;
        while (idx1 < prefixLength) {
            if (value.charAt(idx0) != prefix.charAt(idx1)) {
                return false;
            }
            ++idx1;
            ++idx0;
        }
        return true;
    }

    @Pure
    public static BigInteger toBigInteger(CharSequence value) {
        try {
            boolean negative = false;
            int index = 0;
            char firstChar = value.charAt(0);
            if (firstChar == '-') {
                negative = true;
                ++index;
            } else if (firstChar == '+') {
                ++index;
            }
            int radix = 10;
            if (PrimitiveCastExtensions.startsWith(value, "0x", index) || PrimitiveCastExtensions.startsWith(value, "0X", index)) {
                index += 2;
                radix = 16;
            } else if (PrimitiveCastExtensions.startsWith(value, "#", index)) {
                ++index;
                radix = 16;
            } else if (PrimitiveCastExtensions.startsWith(value, "0", index) && value.length() > 1 + index) {
                ++index;
                radix = 8;
            }
            CharSequence endValue = index > 0 ? value.subSequence(index, value.length()) : value;
            BigInteger number = new BigInteger(endValue.toString(), radix);
            if (negative) {
                return number.negate();
            }
            return number;
        }
        catch (Throwable throwable) {
            return BigInteger.valueOf(0L);
        }
    }

    @Pure
    public static BigDecimal toBigDecimal(CharSequence value) {
        try {
            return new BigDecimal(value.toString());
        }
        catch (Throwable throwable) {
            return BigDecimal.valueOf(0.0);
        }
    }
}

