/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.SRESpecificDataContainer;
import io.sarl.lang.core.SpaceSpecification;
import java.io.Serializable;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class SpaceID
extends SRESpecificDataContainer
implements Serializable,
Comparable<SpaceID> {
    private static final long serialVersionUID = 8764568066583474825L;
    private final UUID id;
    private final UUID contextID;
    private final transient Class<? extends SpaceSpecification<?>> spaceSpec;

    public SpaceID(UUID contextID, UUID id, Class<? extends SpaceSpecification<?>> spaceSpec) {
        assert (contextID != null);
        assert (id != null);
        this.id = id;
        this.contextID = contextID;
        this.spaceSpec = spaceSpec;
    }

    @Pure
    public UUID getID() {
        return this.id;
    }

    @Pure
    public UUID getContextID() {
        return this.contextID;
    }

    @Pure
    public Class<? extends SpaceSpecification<?>> getSpaceSpecification() {
        return this.spaceSpec;
    }

    @Pure
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.contextID == null ? 0 : this.contextID.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceID)) {
            return false;
        }
        SpaceID other = (SpaceID)obj;
        if (!this.equalsContext(other)) {
            return false;
        }
        return this.equalsID(other);
    }

    private boolean equalsContext(SpaceID other) {
        if (this.contextID == null) {
            return other.contextID == null;
        }
        return this.contextID.equals(other.contextID);
    }

    private boolean equalsID(SpaceID other) {
        if (this.id == null) {
            return other.id == null;
        }
        return this.id.equals(other.id);
    }

    @Pure
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.add("type", this.getClass().getSimpleName());
        builder.add("id", this.id);
        builder.add("contextID", this.contextID);
        builder.add("spaceSpec", this.spaceSpec);
        return builder.toString();
    }

    @Override
    @Pure
    public int compareTo(SpaceID otherID) {
        int cmp = this.contextID.compareTo(otherID.contextID);
        if (cmp != 0) {
            return cmp;
        }
        return this.id.compareTo(otherID.id);
    }
}

