/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacities;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public abstract class Skill
extends AgentTrait {
    private final AtomicInteger uses = new AtomicInteger();

    public Skill(Agent agent) {
        super(agent);
    }

    public Skill() {
    }

    @Pure
    @Inline(value="$1.getCaller()", imported={Capacities.class}, constantExpression=true)
    protected AgentTrait getCaller() {
        return Capacities.getCaller();
    }

    void registerUse() {
        int value = this.uses.getAndIncrement();
        if (value == 0) {
            this.install();
        }
    }

    void unregisterUse() {
        int value = this.uses.decrementAndGet();
        if (value == 0) {
            this.uninstall(UninstallationStage.PRE_DESTROY_EVENT);
            this.uninstall(UninstallationStage.POST_DESTROY_EVENT);
        }
    }

    protected void install() {
    }

    @Deprecated
    protected void uninstall() {
    }

    protected void uninstall(UninstallationStage stage) {
        if (stage == UninstallationStage.POST_DESTROY_EVENT) {
            this.uninstall();
        }
    }

    public static enum UninstallationStage {
        PRE_DESTROY_EVENT,
        POST_DESTROY_EVENT;

    }
}

