/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.annotation.PrivateAPI;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.DynamicSkillProvider;
import io.sarl.lang.core.SRESpecificDataContainer;
import io.sarl.lang.core.Skill;
import io.sarl.lang.util.ClearableReference;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.xtext.xbase.lib.Pure;

@PrivateAPI
public final class SREutils {
    private SREutils() {
    }

    @Pure
    public static <S> S getSreSpecificData(SRESpecificDataContainer container, Class<S> type) {
        assert (container != null);
        return container.$getSreSpecificData(type);
    }

    public static void setSreSpecificData(SRESpecificDataContainer container, Object data) {
        assert (container != null);
        container.$setSreSpecificData(data);
    }

    public static <S> S setSreSpecificData(SRESpecificDataContainer container, S data, Class<S> type) {
        assert (container != null);
        S oldData = container.$getSreSpecificData(type);
        container.$setSreSpecificData(data);
        return oldData;
    }

    @Pure
    public static ClearableReference<Skill> getInternalSkillReference(Agent agent, Class<? extends Capacity> type) {
        return agent.$getSkill(type);
    }

    @Pure
    public static <S extends Capacity> S castInternalSkillReference(Agent agent, ClearableReference<Skill> reference, Class<S> type) {
        return agent.$castSkill(type, reference);
    }

    public static ClearableReference<Skill> setInternalSkill(Agent agent, Skill skill, Class<? extends Capacity>[] capacities) {
        assert (capacities != null);
        return agent.$setSkill(skill, capacities);
    }

    @Pure
    public static <S extends Capacity> S getInternalSkill(Agent agent, Class<S> type) {
        return agent.getSkill(type);
    }

    @Deprecated
    public static ClearableReference<Skill> createSkillMapping(Agent agent, Class<? extends Capacity> capacity, Skill skill) {
        return agent.$mapCapacityGetNew(capacity, skill);
    }

    @Deprecated
    public static ClearableReference<Skill> createSkillMappingGetOld(Agent agent, Class<? extends Capacity> capacity, Skill skill) {
        return agent.$mapCapacityGetOld(capacity, skill);
    }

    public static ConcurrentMap<Class<? extends Capacity>, ClearableReference<Skill>> getSkillRepository(Agent agent) {
        return agent.$getSkillRepository();
    }

    public static void setDynamicSkillProvider(Agent agent, DynamicSkillProvider provider) {
        agent.$setDynamicSkillProvider(provider);
    }

    public static void doSkillInstallation(Skill skill) {
        skill.install();
    }

    public static void doSkillUninstallation(Skill skill, Skill.UninstallationStage stage) {
        skill.uninstall(stage);
    }
}

