/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Skill;
import java.lang.reflect.Constructor;
import org.eclipse.xtext.xbase.lib.Pure;

public final class Capacities {
    static final ThreadLocal<AgentTrait> CALLER = new ThreadLocal();
    private static final String CAPACITY_WRAPPER_NAME = "$" + Capacity.ContextAwareCapacityWrapper.class.getSimpleName();

    private Capacities() {
    }

    @Pure
    public static AgentTrait getCaller() {
        return CALLER.get();
    }

    @Pure
    public static <C extends Capacity> C createSkillDelegator(Skill originalSkill, Class<C> capacity, AgentTrait capacityCaller) throws Exception {
        String name = String.valueOf(capacity.getName()) + CAPACITY_WRAPPER_NAME;
        Class<?> type = Class.forName(name, true, capacity.getClassLoader());
        Constructor<?> cons = type.getDeclaredConstructor(capacity, AgentTrait.class);
        return (C)((Capacity)capacity.cast(cons.newInstance(originalSkill, capacityCaller)));
    }

    @Pure
    public static <C extends Capacity> C createSkillDelegatorIfPossible(Skill originalSkill, Class<C> capacity, AgentTrait capacityCaller) throws ClassCastException {
        try {
            return Capacities.createSkillDelegator(originalSkill, capacity, capacityCaller);
        }
        catch (Exception e) {
            return (C)((Capacity)capacity.cast(originalSkill));
        }
    }
}

