/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentProtectedAPIObject;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.UnimplementedCapacityException;
import io.sarl.lang.util.ClearableReference;
import java.lang.ref.WeakReference;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public abstract class AgentTrait
extends AgentProtectedAPIObject {
    private WeakReference<Agent> agentRef;

    protected AgentTrait(Agent agent) {
        this.agentRef = new WeakReference<Agent>(agent);
    }

    protected AgentTrait() {
        this.agentRef = new WeakReference<Object>(null);
    }

    @Override
    @Pure
    protected void toString(ToStringBuilder builder) {
        builder.add("type", this.getClass().getSimpleName());
        builder.add("owner", this.getOwner());
    }

    void setOwner(Agent agent) {
        this.agentRef = new WeakReference<Agent>(agent);
    }

    @Pure
    public Agent getOwner() {
        return (Agent)this.agentRef.get();
    }

    @Pure
    @Inline(value="getOwner().getID()")
    public UUID getID() {
        return this.getOwner().getID();
    }

    @Override
    @Pure
    protected final <S extends Capacity> S getSkill(Class<S> capacity) {
        assert (capacity != null);
        return this.$castSkill(capacity, this.$getSkill(capacity));
    }

    @Pure
    protected <S extends Capacity> S $castSkill(Class<S> capacity, ClearableReference<Skill> skillReference) {
        Capacity skill;
        if (skillReference != null && (skill = (Capacity)capacity.cast(skillReference.get())) != null) {
            return (S)skill;
        }
        throw new UnimplementedCapacityException(capacity, this.getOwner().getID());
    }

    @Override
    protected ClearableReference<Skill> $getSkill(Class<? extends Capacity> capacity) {
        Agent owner = this.getOwner();
        if (owner == null) {
            throw new UnimplementedCapacityException(capacity, null);
        }
        return owner.$getSkill(capacity);
    }

    @Override
    @Inline(value="setSkill($2, $1)")
    protected <S extends Skill> void operator_mappedTo(Class<? extends Capacity> capacity, S skill) {
        this.setSkill(skill, capacity);
    }

    @Override
    @SafeVarargs
    protected final <S extends Skill> S setSkill(S skill, Class<? extends Capacity> ... capacities) {
        Agent owner = this.getOwner();
        if (owner == null) {
            return skill;
        }
        return owner.setSkill(skill, capacities);
    }

    @Override
    protected <S extends Capacity> S clearSkill(Class<S> capacity) {
        Agent owner = this.getOwner();
        if (owner == null) {
            return null;
        }
        return owner.clearSkill(capacity);
    }

    @Override
    @Pure
    protected boolean hasSkill(Class<? extends Capacity> capacity) {
        Agent owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        return owner.hasSkill(capacity);
    }

    @Override
    @Pure
    public boolean isMe(Address address) {
        Agent owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        return owner.isMe(address);
    }

    @Override
    @Pure
    public boolean isMe(UUID uID) {
        Agent owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        return owner.isMe(uID);
    }

    @Override
    @Pure
    public boolean isFromMe(Event event) {
        Agent owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        return owner.isFromMe(event);
    }
}

