/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import com.google.common.reflect.TypeToken;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.AgentProtectedAPIObject;
import io.sarl.lang.core.BuiltinCapacitiesProvider;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.DefaultSkill;
import io.sarl.lang.core.DynamicSkillProvider;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Identifiable;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.UnimplementedCapacityException;
import io.sarl.lang.util.ClearableReference;
import io.sarl.lang.util.OutParameter;
import java.lang.reflect.Constructor;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@SarlSpecification(value="0.10")
public class Agent
extends AgentProtectedAPIObject
implements Identifiable {
    private final UUID id;
    private final UUID parentID;
    private ConcurrentMap<Class<? extends Capacity>, ClearableReference<Skill>> skillRepository = new ConcurrentHashMap<Class<? extends Capacity>, ClearableReference<Skill>>();
    private DynamicSkillProvider skillProvider;

    @Deprecated
    @Inject
    public Agent(BuiltinCapacitiesProvider provider, UUID parentID, UUID agentID) {
        this(parentID, agentID);
        Map<Class<? extends Capacity>, Skill> builtinCapacities;
        if (provider != null && (builtinCapacities = provider.getBuiltinCapacities(this)) != null && !builtinCapacities.isEmpty()) {
            for (Map.Entry<Class<? extends Capacity>, Skill> bic : builtinCapacities.entrySet()) {
                this.$mapCapacityGetOld(bic.getKey(), bic.getValue());
            }
        }
    }

    public Agent(UUID parentID, UUID agentID) {
        this(parentID, agentID, null);
    }

    @Inject
    public Agent(UUID parentID, UUID agentID, DynamicSkillProvider skillProvider) {
        this.parentID = parentID;
        this.id = agentID == null ? UUID.randomUUID() : agentID;
        this.skillProvider = skillProvider;
    }

    @Override
    @Pure
    protected void toString(ToStringBuilder builder) {
        builder.add("type", this.getClass().getSimpleName());
        builder.add("id", this.id);
        builder.add("parentID", this.parentID);
    }

    @Pure
    public UUID getParentID() {
        return this.parentID;
    }

    @Override
    @Pure
    public UUID getID() {
        return this.id;
    }

    void $setDynamicSkillProvider(DynamicSkillProvider provider) {
        this.skillProvider = provider;
    }

    ConcurrentMap<Class<? extends Capacity>, ClearableReference<Skill>> $getSkillRepository() {
        return this.skillRepository;
    }

    ClearableReference<Skill> $mapCapacityGetOld(Class<? extends Capacity> capacity, Skill skill) {
        return this.$getSkillRepository().put(capacity, new ClearableReference<Skill>(skill));
    }

    ClearableReference<Skill> $mapCapacityGetNew(Class<? extends Capacity> capacity, Skill skill) {
        ClearableReference<Skill> newReference = new ClearableReference<Skill>(skill);
        this.$getSkillRepository().put(capacity, newReference);
        return newReference;
    }

    Pair<ClearableReference<Skill>, ClearableReference<Skill>> $mapCapacityGetOldAndNew(Class<? extends Capacity> capacity, Skill skill) {
        ClearableReference<Skill> newReference = new ClearableReference<Skill>(skill);
        ClearableReference<Skill> oldReference = this.$getSkillRepository().put(capacity, newReference);
        return Pair.of(oldReference, newReference);
    }

    @Inline(value="setSkill($2, $1)")
    @Deprecated
    protected <S extends Skill> S setSkill(Class<? extends Capacity> capacity, S skill) {
        return this.setSkill(skill, capacity);
    }

    @Override
    @SafeVarargs
    protected final <S extends Skill> S setSkill(S skill, Class<? extends Capacity> ... capacities) {
        this.$setSkill(skill, capacities);
        return skill;
    }

    @SafeVarargs
    protected final ClearableReference<Skill> $setSkill(Skill skill, Class<? extends Capacity> ... capacities) {
        assert (skill != null) : "the skill parameter must not be null";
        skill.setOwner(this);
        OutParameter<ClearableReference<Skill>> newRef = new OutParameter<ClearableReference<Skill>>();
        if (capacities == null || capacities.length == 0) {
            Agent.runOnImplementedCapacities(skill, capacity -> {
                Skill oldSkill;
                ClearableReference<Skill> oldS;
                if (newRef.get() == null) {
                    Pair<ClearableReference<Skill>, ClearableReference<Skill>> pair = this.$mapCapacityGetOldAndNew((Class<? extends Capacity>)capacity, skill);
                    newRef.set(pair.getValue());
                    oldS = pair.getKey();
                } else {
                    oldS = this.$mapCapacityGetOld((Class<? extends Capacity>)capacity, skill);
                }
                skill.registerUse();
                if (oldS != null && (oldSkill = oldS.clear()) != null && oldSkill != skill) {
                    oldSkill.unregisterUse();
                }
            });
        } else {
            Class<? extends Capacity>[] classArray = capacities;
            int n = capacities.length;
            int n2 = 0;
            while (n2 < n) {
                Skill oldSkill;
                ClearableReference<Skill> oldS;
                Class<? extends Capacity> capacity2 = classArray[n2];
                assert (capacity2 != null) : "the capacity parameter must not be null";
                assert (capacity2.isInterface()) : "the capacity parameter must be an interface";
                if (!capacity2.isInstance(skill)) {
                    throw new InvalidParameterException("the skill must implement the given capacity " + capacity2.getName());
                }
                if (newRef.get() == null) {
                    Pair<ClearableReference<Skill>, ClearableReference<Skill>> pair = this.$mapCapacityGetOldAndNew(capacity2, skill);
                    newRef.set(pair.getValue());
                    oldS = pair.getKey();
                } else {
                    oldS = this.$mapCapacityGetOld(capacity2, skill);
                }
                skill.registerUse();
                if (oldS != null && (oldSkill = oldS.clear()) != null && oldSkill != skill) {
                    oldSkill.unregisterUse();
                }
                ++n2;
            }
        }
        return (ClearableReference)newRef.get();
    }

    private static void runOnImplementedCapacities(Skill skill, Procedures.Procedure1<? super Class<? extends Capacity>> callback) {
        TypeToken.of(skill.getClass()).getTypes().interfaces().stream().forEach(it -> {
            Class type = it.getRawType();
            if (Capacity.class.isAssignableFrom(type) && !Capacity.class.equals(type)) {
                callback.apply(type.asSubclass(Capacity.class));
            }
        });
    }

    @Override
    @Inline(value="setSkill($2, $1)")
    protected <S extends Skill> void operator_mappedTo(Class<? extends Capacity> capacity, S skill) {
        this.setSkill(skill, capacity);
    }

    @Override
    protected <S extends Capacity> S clearSkill(Class<S> capacity) {
        Skill skill;
        assert (capacity != null);
        ClearableReference reference = (ClearableReference)this.$getSkillRepository().remove(capacity);
        if (reference != null && (skill = (Skill)reference.clear()) != null) {
            skill.unregisterUse();
            return (S)((Capacity)capacity.cast(skill));
        }
        return null;
    }

    @Override
    @Pure
    protected final <S extends Capacity> S getSkill(Class<S> capacity) {
        assert (capacity != null);
        return this.$castSkill(capacity, this.$getSkill(capacity));
    }

    @Pure
    protected <S extends Capacity> S $castSkill(Class<S> capacity, ClearableReference<Skill> skillReference) {
        Capacity skill = (Capacity)capacity.cast(skillReference.get());
        if (skill == null) {
            throw new UnimplementedCapacityException(capacity, this.getID());
        }
        return (S)skill;
    }

    @Override
    @Pure
    protected ClearableReference<Skill> $getSkill(Class<? extends Capacity> capacity) {
        ClearableReference skill = (ClearableReference)this.$getSkillRepository().get(capacity);
        if (skill == null) {
            ClearableReference<Skill> reference;
            DynamicSkillProvider dsp = this.skillProvider;
            if (dsp != null && (reference = dsp.installSkill(this, capacity)) != null) {
                return reference;
            }
            DefaultSkill annotation = capacity.getAnnotation(DefaultSkill.class);
            if (annotation != null) {
                try {
                    Class<? extends Skill> type = annotation.value();
                    try {
                        Constructor<? extends Skill> cons = type.getConstructor(Agent.class);
                        cons.setAccessible(true);
                        Skill skillInstance = cons.newInstance(this);
                        return this.$setSkill(skillInstance, new Class[0]);
                    }
                    catch (Throwable exception) {
                        Constructor<? extends Skill> cons = type.getConstructor(new Class[0]);
                        cons.setAccessible(true);
                        Skill skillInstance = cons.newInstance(new Object[0]);
                        return this.$setSkill(skillInstance, new Class[0]);
                    }
                }
                catch (Throwable exception) {
                    throw new UnimplementedCapacityException(capacity, this.getID(), exception);
                }
            }
            throw new UnimplementedCapacityException(capacity, this.getID());
        }
        return skill;
    }

    @Override
    @Pure
    protected boolean hasSkill(Class<? extends Capacity> capacity) {
        assert (capacity != null);
        if (!this.$getSkillRepository().containsKey(capacity)) {
            ClearableReference<Skill> reference;
            if (this.skillProvider != null && (reference = this.skillProvider.installSkill(this, capacity)) != null) {
                return true;
            }
            DefaultSkill annotation = capacity.getAnnotation(DefaultSkill.class);
            return annotation != null && annotation.value() != null;
        }
        return true;
    }

    @Override
    @Pure
    @Inline(value="($1 != null && $0getID().equals($1.getUUID()))", constantExpression=true)
    protected boolean isMe(Address address) {
        return address != null && this.isMe(address.getUUID());
    }

    @Override
    @Pure
    @Inline(value="getID().equals($1)")
    protected boolean isMe(UUID uID) {
        return uID != null && this.getID().equals(uID);
    }

    @Override
    @Pure
    @Inline(value="($1 != null && $0getID().equals($1.getSource().getUUID()))", constantExpression=true)
    protected boolean isFromMe(Event event) {
        return event != null && this.isMe(event.getSource());
    }
}

