/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eventdispatching;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import io.sarl.eventdispatching.BehaviorGuardEvaluator;
import io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry;
import io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry$1$AssertEvaluator$;
import io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry$2$AssertEvaluator$;
import io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry$3$AssertEvaluator$;
import io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry$EvaluatorCollectionFilteringIterator$1$AssertEvaluator$;
import io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry$EvaluatorCollectionFilteringIterator$2$AssertEvaluator$;
import io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry$EvaluatorCollectionIterator$1$AssertEvaluator$;
import io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry$MethodIdentifier$1$AssertEvaluator$;
import io.sarl.eventdispatching.Messages;
import io.sarl.lang.annotation.DefaultValue;
import io.sarl.lang.annotation.DefaultValueSource;
import io.sarl.lang.annotation.DefaultValueUse;
import io.sarl.lang.annotation.PerceptGuardEvaluator;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSourceCode;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.Event;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.10")
@SarlElementType(value=10)
public class BehaviorGuardEvaluatorRegistry {
    private static final LoadingCache<Class<?>, ImmutableSet<Class<?>>> FLATTEN_HIERARCHY_CACHE = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ImmutableSet<Class<?>>>(){

        @Override
        public ImmutableSet<Class<?>> load(Class<?> it) throws Exception {
            return BehaviorGuardEvaluatorRegistry.getTypeHierarchyOnDemand(it);
        }
    });
    private static final LoadingCache<Class<?>, Map<Class<? extends Event>, Collection<Method>>> PERCEPT_GUARD_EVALUATOR_METHOD_CACHE = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, Map<Class<? extends Event>, Collection<Method>>>(){

        @Override
        public Map<Class<? extends Event>, Collection<Method>> load(Class<?> it) throws Exception {
            return BehaviorGuardEvaluatorRegistry.getAnnotatedMethodMapOnDemand(it);
        }
    });
    private final Map<Class<? extends Event>, Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> behaviorGuardEvaluators;
    private boolean active = true;
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static final Functions.Function1 $DEFAULT_VALUE$REGISTER_0 = null;
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static final Procedures.Procedure1 $DEFAULT_VALUE$REGISTER_1 = null;
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static final Procedures.Procedure1 $DEFAULT_VALUE$UNREGISTERALL_0 = null;
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static final Procedures.Procedure1 $DEFAULT_VALUE$UNREGISTER_0 = null;

    private static Class<?> reloadClass(Class<?> context, Class<?> type) {
        ClassLoader ld = context.getClassLoader();
        if (ld == null) {
            ld = type.getClassLoader();
        }
        try {
            return ld.loadClass(type.getName());
        }
        catch (Throwable _t) {
            if (_t instanceof Throwable) {
                return type;
            }
            throw Exceptions.sneakyThrow(_t);
        }
    }

    @Pure
    private static <T> T safeCast(Object obj) {
        return (T)obj;
    }

    @Pure
    private static Set<Class<?>> exploreTypeHierarchy(Class<?> concreteClass) {
        return (Set)BehaviorGuardEvaluatorRegistry.safeCast(TypeToken.of(concreteClass).getTypes().rawTypes());
    }

    @Pure
    private static ImmutableSet<Class<?>> getTypeHierarchyOnDemand(Class<?> concreteClass) {
        Set<Class<?>> typeHierarchy;
        ImmutableSet<Class<?>> _xblockexpression;
        block4: {
            _xblockexpression = null;
            assert (new BehaviorGuardEvaluatorRegistry$1$AssertEvaluator$(concreteClass).$$result);
            typeHierarchy = BehaviorGuardEvaluatorRegistry.exploreTypeHierarchy(concreteClass);
            try {
                Class<?> eventType = BehaviorGuardEvaluatorRegistry.reloadClass(concreteClass, Event.class);
                boolean _isAssignableFrom = eventType.isAssignableFrom(concreteClass);
                if (_isAssignableFrom) {
                    Functions.Function1<Class, Boolean> _function = it -> eventType.isAssignableFrom((Class<?>)it);
                    return ImmutableSet.copyOf(IterableExtensions.filter(typeHierarchy, _function));
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) break block4;
                throw Exceptions.sneakyThrow(_t);
            }
        }
        _xblockexpression = ImmutableSet.copyOf(typeHierarchy);
        return _xblockexpression;
    }

    @Pure
    private static Map<Class<? extends Event>, Collection<Method>> getAnnotatedMethodMapOnDemand(Class<?> concreteClass) {
        ImmutableMap<Class<? extends Event>, Collection<Method>> _xblockexpression = null;
        assert (new BehaviorGuardEvaluatorRegistry$2$AssertEvaluator$(concreteClass).$$result);
        Set<Class<?>> typeHierarchy = BehaviorGuardEvaluatorRegistry.exploreTypeHierarchy(concreteClass);
        Functions.Function1<Class, Boolean> _function = it -> !it.isInterface() && !Objects.equal(Object.class, it);
        Iterable<Class> supertypes = IterableExtensions.filter(typeHierarchy, _function);
        TreeMap<MethodIdentifier, Method> identifiers = new TreeMap<MethodIdentifier, Method>();
        for (Class supertype : supertypes) {
            Method[] _declaredMethods;
            Method[] methodArray = _declaredMethods = supertype.getDeclaredMethods();
            int n = _declaredMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(PerceptGuardEvaluator.class) && !method.isSynthetic()) {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    MethodIdentifier ident = new MethodIdentifier(method, parameterTypes);
                    identifiers.putIfAbsent(ident, method);
                }
                ++n2;
            }
        }
        Comparator _function_1 = (elt1, elt2) -> {
            String _name = elt1.getName();
            String _name_1 = elt2.getName();
            return _name.compareTo(_name_1);
        };
        TreeMap buffer = new TreeMap(_function_1);
        Collection _values = identifiers.values();
        for (Method method_1 : _values) {
            Class[] parameterTypes_1 = method_1.getParameterTypes();
            class _1 {
                final boolean $$result;

                _1(Class[] classArray) {
                    this.$$result = BehaviorGuardEvaluatorRegistry.access$3(classArray);
                }
            }
            assert (new _1((Class[])parameterTypes_1).$$result);
            Class<?> _get = parameterTypes_1[0];
            Class<?> eventType = _get;
            ArrayList methods = (ArrayList)buffer.get(eventType);
            if (methods == null) {
                methods = CollectionLiterals.newArrayList();
                buffer.put(eventType, methods);
            }
            methods.add(method_1);
        }
        _xblockexpression = ImmutableMap.copyOf(buffer);
        return _xblockexpression;
    }

    @Pure
    private static boolean checkEventHandlerPrototype(Class<?>[] parameterTypes) {
        block3: {
            try {
                if (parameterTypes.length == 2 && parameterTypes[0] != null && BehaviorGuardEvaluatorRegistry.reloadClass(parameterTypes[0], Event.class).isAssignableFrom(parameterTypes[0]) && parameterTypes[1] != null && BehaviorGuardEvaluatorRegistry.reloadClass(parameterTypes[1], Collection.class).isAssignableFrom(parameterTypes[1])) {
                    return true;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) break block3;
                throw Exceptions.sneakyThrow(_t);
            }
        }
        return false;
    }

    @Pure
    private static Map<Class<? extends Event>, Collection<Method>> getAnnotatedMethodsPerEvent(Class<?> listenerType) {
        Map<Class<? extends Event>, Collection<Method>> _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = PERCEPT_GUARD_EVALUATOR_METHOD_CACHE.getUnchecked(listenerType);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception ex = (Exception)_t;
                Throwables.throwIfUnchecked(ex);
                throw new RuntimeException(ex);
            }
            throw Exceptions.sneakyThrow(_t);
        }
        return _xtrycatchfinallyexpression;
    }

    public BehaviorGuardEvaluatorRegistry() {
        this(true);
    }

    public BehaviorGuardEvaluatorRegistry(final boolean concurrent) {
        this((Map<Class<? extends Event>, Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>>)new Functions.Function0<Map<Class<? extends Event>, Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>>>(){

            @Override
            public Map<Class<? extends Event>, Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> apply() {
                Map _xifexpression = null;
                _xifexpression = concurrent ? Maps.newConcurrentMap() : Maps.newHashMap();
                return _xifexpression;
            }
        }.apply());
    }

    public BehaviorGuardEvaluatorRegistry(Map<Class<? extends Event>, Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> buffer) {
        assert (new BehaviorGuardEvaluatorRegistry$3$AssertEvaluator$((BehaviorGuardEvaluatorRegistry)this, buffer).$$result);
        this.behaviorGuardEvaluators = buffer;
    }

    @DefaultValueSource
    public void register(Object listener, @DefaultValue(value="io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry#REGISTER_0") Functions.Function1<? super Event, ? extends Boolean> filter, @DefaultValue(value="io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry#REGISTER_1") Procedures.Procedure1<? super Object> callback) {
        if (this.active) {
            boolean firstInit = false;
            EvaluatorIterator listenerMethods = new EvaluatorIterator(listener);
            while (listenerMethods.hasNext()) {
                Object entry = listenerMethods.next();
                Class eventType = (Class)((Pair)entry).getKey();
                Collection eventMethodsInListener = (Collection)((Pair)entry).getValue();
                Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> pair = this.behaviorGuardEvaluators.get(eventType);
                Set<BehaviorGuardEvaluator> eventSubscribers = null;
                if (pair == null) {
                    CopyOnWriteArraySet<BehaviorGuardEvaluator> _copyOnWriteArraySet = new CopyOnWriteArraySet<BehaviorGuardEvaluator>();
                    eventSubscribers = _copyOnWriteArraySet;
                    Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> _pair = new Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>(filter, eventSubscribers);
                    this.behaviorGuardEvaluators.put(eventType, _pair);
                    firstInit = true;
                } else {
                    eventSubscribers = pair.getValue();
                }
                boolean _addAll = eventSubscribers.addAll(eventMethodsInListener);
                if (!_addAll) continue;
                firstInit = true;
            }
            if (firstInit && callback != null) {
                callback.apply(listener);
            }
        }
    }

    @DefaultValueSource
    public void unregisterAll(@DefaultValue(value="io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry#UNREGISTERALL_0") Procedures.Procedure1<? super Object> callback) {
        if (this.active) {
            this.active = false;
            try {
                if (callback != null) {
                    Iterator<Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> iterator = this.behaviorGuardEvaluators.values().iterator();
                    Comparator _function = (term1, term2) -> {
                        if (term1 == term2) {
                            return 0;
                        }
                        int _identityHashCode = System.identityHashCode(term1);
                        int _identityHashCode_1 = System.identityHashCode(term2);
                        return Integer.compare(_identityHashCode, _identityHashCode_1);
                    };
                    TreeSet<Object> subscribers = new TreeSet<Object>(_function);
                    while (iterator.hasNext()) {
                        Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> pair = iterator.next();
                        Set<BehaviorGuardEvaluator> _value = pair.getValue();
                        for (BehaviorGuardEvaluator evaluator : _value) {
                            Object _target = evaluator.getTarget();
                            boolean _add = subscribers.add(_target);
                            if (!_add) continue;
                            callback.apply(evaluator.getTarget());
                        }
                        iterator.remove();
                    }
                } else {
                    this.behaviorGuardEvaluators.clear();
                }
            }
            finally {
                this.active = true;
            }
        }
    }

    @DefaultValueSource
    public void unregister(Object listener, @DefaultValue(value="io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry#UNREGISTER_0") Procedures.Procedure1<? super Object> callback) {
        if (this.active) {
            EvaluatorIterator listenerMethods = new EvaluatorIterator(listener);
            Procedures.Procedure1<? super Object> listenerCallback = callback;
            while (listenerMethods.hasNext()) {
                Object entry = listenerMethods.next();
                Class eventType = (Class)((Pair)entry).getKey();
                Collection listenerMethodsForType = (Collection)((Pair)entry).getValue();
                Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> pair = this.behaviorGuardEvaluators.get(eventType);
                if (listenerCallback != null && pair != null && pair.getValue() != null && !pair.getValue().isEmpty()) {
                    listenerCallback.apply(listener);
                    listenerCallback = null;
                }
                if (pair != null && pair.getValue() != null && pair.getValue().removeAll(listenerMethodsForType)) continue;
                if (pair != null && pair.getValue() != null) {
                    pair.getValue().removeAll(listenerMethodsForType);
                }
                String _format = MessageFormat.format(Messages.BehaviorGuardEvaluatorRegistry_0, listener);
                throw new IllegalArgumentException(_format);
            }
        }
    }

    @Pure
    public Iterable<BehaviorGuardEvaluator> getBehaviorGuardEvaluators(Event event) {
        ImmutableSet<Class<?>> eventTypes = BehaviorGuardEvaluatorRegistry.flattenHierarchy(event.getClass());
        Iterable<BehaviorGuardEvaluator> _function = () -> {
            Iterator _iterator = eventTypes.iterator();
            return new EvaluatorCollectionIterator(this.behaviorGuardEvaluators, event, _iterator, false);
        };
        return _function;
    }

    @Pure
    public Iterable<BehaviorGuardEvaluator> getBehaviorGuardEvaluatorsFor(Event event, Object listener) {
        ImmutableSet<Class<?>> eventTypes = BehaviorGuardEvaluatorRegistry.flattenHierarchy(event.getClass());
        Iterable<BehaviorGuardEvaluator> _function = () -> {
            EvaluatorCollectionFilteringIterator _xblockexpression = null;
            Iterator _iterator = eventTypes.iterator();
            EvaluatorCollectionIterator base = new EvaluatorCollectionIterator(this.behaviorGuardEvaluators, event, _iterator, true);
            _xblockexpression = new EvaluatorCollectionFilteringIterator(base, listener);
            return _xblockexpression;
        };
        return _function;
    }

    @Pure
    public boolean hasRegisteredEventListener(Class<?> type) {
        Collection<Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> _values = this.behaviorGuardEvaluators.values();
        for (Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> pair : _values) {
            Set<BehaviorGuardEvaluator> listeners = pair.getValue();
            if (listeners == null) continue;
            for (BehaviorGuardEvaluator evaluator : listeners) {
                Object target = evaluator.getTarget();
                boolean _isInstance = type.isInstance(target);
                if (!_isInstance) continue;
                return true;
            }
        }
        return false;
    }

    @Pure
    public <T> int getRegisteredEventListeners(Class<T> type, Collection<? super T> collection) {
        int _xblockexpression = 0;
        Comparator _function = (elt1, elt2) -> {
            int _xblockexpression_1 = 0;
            if (elt1 == elt2) {
                return 0;
            }
            int _identityHashCode = System.identityHashCode(elt1);
            int _identityHashCode_1 = System.identityHashCode(elt2);
            _xblockexpression_1 = Integer.compare(_identityHashCode, _identityHashCode_1);
            return _xblockexpression_1;
        };
        TreeSet<Object> addedObjects = new TreeSet<Object>(_function);
        Collection<Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> _values = this.behaviorGuardEvaluators.values();
        for (Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> pair : _values) {
            Set<BehaviorGuardEvaluator> listeners = pair.getValue();
            if (listeners == null) continue;
            for (BehaviorGuardEvaluator evaluator : listeners) {
                Object target = evaluator.getTarget();
                if (!type.isInstance(target) || !addedObjects.add(target) || collection == null) continue;
                T _cast = type.cast(target);
                collection.add(_cast);
            }
        }
        _xblockexpression = addedObjects.size();
        return _xblockexpression;
    }

    @Pure
    public <T> Iterable<T> getRegisteredEventListeners(Class<T> type) {
        Comparator _function = (elt1, elt2) -> {
            int _xblockexpression = 0;
            if (elt1 == elt2) {
                return 0;
            }
            int _identityHashCode = System.identityHashCode(elt1);
            int _identityHashCode_1 = System.identityHashCode(elt2);
            _xblockexpression = Integer.compare(_identityHashCode, _identityHashCode_1);
            return _xblockexpression;
        };
        TreeSet addedObjects = new TreeSet(_function);
        Functions.Function1<Pair, Set> _function_1 = it -> (Set)it.getValue();
        Functions.Function1<BehaviorGuardEvaluator, Object> _function_2 = it -> it.getTarget();
        Functions.Function1<Object, Boolean> _function_3 = it -> type.isInstance(it) && addedObjects.add(it);
        Functions.Function1<Object, Object> _function_4 = it -> type.cast(it);
        return IterableExtensions.map(IterableExtensions.filter(IterableExtensions.map(Iterables.concat(IterableExtensions.map(this.behaviorGuardEvaluators.values(), _function_1)), _function_2), _function_3), _function_4);
    }

    private static ImmutableSet<Class<?>> flattenHierarchy(Class<?> concreteClass) {
        ImmutableSet<Class<?>> _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = FLATTEN_HIERARCHY_CACHE.getUnchecked(concreteClass);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                Throwables.throwIfUnchecked(e.getCause());
                Throwable _cause = e.getCause();
                throw new RuntimeException(_cause);
            }
            throw Exceptions.sneakyThrow(_t);
        }
        return _xtrycatchfinallyexpression;
    }

    @DefaultValueUse(value="java.lang.Object,(io.sarl.lang.core.Event)=>java.lang.Boolean,(java.lang.Object)=>void")
    @SyntheticMember
    public final void register(Object listener) {
        this.register(listener, $DEFAULT_VALUE$REGISTER_0, $DEFAULT_VALUE$REGISTER_1);
    }

    @DefaultValueUse(value="java.lang.Object,(io.sarl.lang.core.Event)=>java.lang.Boolean,(java.lang.Object)=>void")
    @SyntheticMember
    public final void register(Object listener, Functions.Function1<? super Event, ? extends Boolean> filter) {
        this.register(listener, filter, $DEFAULT_VALUE$REGISTER_1);
    }

    @DefaultValueUse(value="java.lang.Object,(io.sarl.lang.core.Event)=>java.lang.Boolean,(java.lang.Object)=>void")
    @SyntheticMember
    public final void register(Object listener, Procedures.Procedure1<? super Object> callback) {
        this.register(listener, $DEFAULT_VALUE$REGISTER_0, callback);
    }

    @DefaultValueUse(value="(java.lang.Object)=>void")
    @SyntheticMember
    public final void unregisterAll() {
        this.unregisterAll($DEFAULT_VALUE$UNREGISTERALL_0);
    }

    @DefaultValueUse(value="java.lang.Object,(java.lang.Object)=>void")
    @SyntheticMember
    public final void unregister(Object listener) {
        this.unregister(listener, $DEFAULT_VALUE$UNREGISTER_0);
    }

    @Pure
    @SyntheticMember
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BehaviorGuardEvaluatorRegistry other = (BehaviorGuardEvaluatorRegistry)obj;
        if (other.active != this.active) {
            return false;
        }
        return super.equals(obj);
    }

    @Pure
    @SyntheticMember
    public int hashCode() {
        int result = super.hashCode();
        int prime = 31;
        result = 31 * result + (this.active ? 1231 : 1237);
        return result;
    }

    static /* synthetic */ boolean access$3(Class[] classArray) {
        return BehaviorGuardEvaluatorRegistry.checkEventHandlerPrototype(classArray);
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class EvaluatorCollectionFilteringIterator
    implements Iterator<BehaviorGuardEvaluator> {
        private final Iterator<BehaviorGuardEvaluator> iterator;
        private final Object subscriber;
        private BehaviorGuardEvaluator next;

        public EvaluatorCollectionFilteringIterator(Iterator<BehaviorGuardEvaluator> iterator, Object subscriber) {
            assert (new BehaviorGuardEvaluatorRegistry$EvaluatorCollectionFilteringIterator$1$AssertEvaluator$((EvaluatorCollectionFilteringIterator)this, iterator).$$result);
            class _1 {
                final boolean $$result;
                final /* synthetic */ EvaluatorCollectionFilteringIterator this$1;

                _1(EvaluatorCollectionFilteringIterator evaluatorCollectionFilteringIterator, Object object) {
                    this.this$1 = evaluatorCollectionFilteringIterator;
                    this.$$result = object != null;
                }
            }
            assert (new _1((EvaluatorCollectionFilteringIterator)this, (Object)subscriber).$$result);
            this.iterator = iterator;
            this.subscriber = subscriber;
            this.searchNext();
        }

        private void searchNext() {
            this.next = null;
            while (this.next == null && this.iterator.hasNext()) {
                BehaviorGuardEvaluator evaluator = this.iterator.next();
                Object _target = evaluator.getTarget();
                if (_target != this.subscriber) continue;
                this.next = evaluator;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public BehaviorGuardEvaluator next() {
            assert (new BehaviorGuardEvaluatorRegistry$EvaluatorCollectionFilteringIterator$2$AssertEvaluator$((EvaluatorCollectionFilteringIterator)this).$$result);
            BehaviorGuardEvaluator next = this.next;
            this.searchNext();
            return next;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        static /* synthetic */ BehaviorGuardEvaluator access$1(EvaluatorCollectionFilteringIterator evaluatorCollectionFilteringIterator) {
            return evaluatorCollectionFilteringIterator.next;
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class EvaluatorCollectionIterator
    implements Iterator<BehaviorGuardEvaluator> {
        private final Map<Class<? extends Event>, Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> behaviorGuardEvaluators;
        private final Event event;
        private final Iterator<Class<?>> eventTypeIterator;
        private final boolean skipSubscriberFiltering;
        private Iterator<BehaviorGuardEvaluator> evaluators;

        public EvaluatorCollectionIterator(Map<Class<? extends Event>, Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> behaviorGuardEvaluators, Event event, Iterator<Class<?>> eventTypes, boolean skipSubscriberFiltering) {
            assert (new BehaviorGuardEvaluatorRegistry$EvaluatorCollectionIterator$1$AssertEvaluator$((EvaluatorCollectionIterator)this, behaviorGuardEvaluators).$$result);
            class _1 {
                final boolean $$result;
                final /* synthetic */ EvaluatorCollectionIterator this$1;

                _1(EvaluatorCollectionIterator evaluatorCollectionIterator, Event event) {
                    this.this$1 = evaluatorCollectionIterator;
                    this.$$result = event != null;
                }
            }
            assert (new _1((EvaluatorCollectionIterator)this, (Event)event).$$result);
            this.skipSubscriberFiltering = skipSubscriberFiltering;
            this.behaviorGuardEvaluators = behaviorGuardEvaluators;
            this.event = event;
            this.eventTypeIterator = eventTypes;
            this.searchNext();
        }

        private void searchNext() {
            while ((this.evaluators == null || !this.evaluators.hasNext()) && this.eventTypeIterator.hasNext()) {
                Class<?> eventType = this.eventTypeIterator.next();
                Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> eventSubscribers = this.behaviorGuardEvaluators.get(eventType);
                boolean _isValidSubscriber = this.isValidSubscriber(eventSubscribers);
                if (!_isValidSubscriber) continue;
                this.evaluators = eventSubscribers.getValue().iterator();
            }
        }

        @Pure
        protected boolean isValidSubscriber(Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> subscriber) {
            if (subscriber != null && subscriber.getValue() != null) {
                return this.skipSubscriberFiltering || subscriber.getKey() == null || subscriber.getKey().apply(this.event) != null && subscriber.getKey().apply(this.event) != false;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.evaluators != null && this.evaluators.hasNext();
        }

        @Override
        public BehaviorGuardEvaluator next() {
            if (this.evaluators == null) {
                this.searchNext();
            }
            BehaviorGuardEvaluator next = this.evaluators.next();
            this.searchNext();
            return next;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EvaluatorCollectionIterator other = (EvaluatorCollectionIterator)obj;
            if (other.skipSubscriberFiltering != this.skipSubscriberFiltering) {
                return false;
            }
            return super.equals(obj);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            int prime = 31;
            result = 31 * result + (this.skipSubscriberFiltering ? 1231 : 1237);
            return result;
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static class EvaluatorIterator
    implements Iterator<Pair<Class<? extends Event>, Collection<BehaviorGuardEvaluator>>> {
        private final Object listener;
        private final Iterator<Map.Entry<Class<? extends Event>, Collection<Method>>> iterator;

        public EvaluatorIterator(Object listener) {
            Map methods = BehaviorGuardEvaluatorRegistry.getAnnotatedMethodsPerEvent(listener.getClass());
            this.iterator = methods.entrySet().iterator();
            this.listener = listener;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Pair<Class<? extends Event>, Collection<BehaviorGuardEvaluator>> next() {
            Pair<Class<? extends Event>, Collection<BehaviorGuardEvaluator>> _xblockexpression = null;
            Map.Entry<Class<? extends Event>, Collection<Method>> entry = this.iterator.next();
            Class<? extends Event> _key = entry.getKey();
            Function _function = it -> new BehaviorGuardEvaluator(this.listener, (Method)it);
            Collection _transform = Collections2.transform(entry.getValue(), _function);
            _xblockexpression = new Pair<Class<? extends Event>, Collection<BehaviorGuardEvaluator>>(_key, _transform);
            return _xblockexpression;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    @SarlSpecification(value="0.10")
    @SarlElementType(value=10)
    private static final class MethodIdentifier
    implements Comparable<MethodIdentifier> {
        private final String name;
        private final List<Class<?>> parameterTypes;

        public MethodIdentifier(Method method, Class<?>[] parameterTypes) {
            String _plus;
            Class<?> _declaringClass = method.getDeclaringClass();
            String _name = method.getName();
            this.name = _plus = _declaringClass + _name;
            this.parameterTypes = Arrays.asList(parameterTypes);
        }

        @Pure
        public int hashCode() {
            return Objects.hashCode(this.name, this.parameterTypes);
        }

        @Pure
        public boolean equals(Object object) {
            if (object instanceof MethodIdentifier) {
                return Objects.equal(this.name, ((MethodIdentifier)object).name) && Objects.equal(this.parameterTypes, ((MethodIdentifier)object).parameterTypes);
            }
            return false;
        }

        @Override
        public int compareTo(MethodIdentifier obj) {
            int _size_1;
            if (obj == null) {
                return -1;
            }
            int cmp = this.name.compareTo(obj.name);
            if (cmp != 0) {
                return cmp;
            }
            int _size = this.parameterTypes.size();
            cmp = Integer.compare(_size, _size_1 = obj.parameterTypes.size());
            if (cmp != 0) {
                return cmp;
            }
            Iterator<Class<?>> it1 = this.parameterTypes.iterator();
            Iterator<Class<?>> it2 = obj.parameterTypes.iterator();
            while (it1.hasNext()) {
                String _name_1;
                assert (new BehaviorGuardEvaluatorRegistry$MethodIdentifier$1$AssertEvaluator$((MethodIdentifier)this, it2).$$result);
                String _name = it1.next().getName();
                int _spaceship = _name.compareTo(_name_1 = it2.next().getName());
                cmp = _spaceship;
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        @Pure
        public String toString() {
            return this.name;
        }
    }
}

