/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eventdispatching;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import io.sarl.eventdispatching.BehaviorGuardEvaluator$1$AssertEvaluator$;
import io.sarl.eventdispatching.Messages;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSpecification;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.10")
@SarlElementType(value=10)
public class BehaviorGuardEvaluator {
    private final Object target;
    private final Method method;

    public BehaviorGuardEvaluator(Object target, Method method) {
        assert (new BehaviorGuardEvaluator$1$AssertEvaluator$((BehaviorGuardEvaluator)this, (Object)target).$$result);
        this.target = target;
        this.method = method;
    }

    public void evaluateGuard(Object event, Collection<Runnable> behaviorsMethodsToExecute) {
        try {
            try {
                this.method.setAccessible(true);
                this.method.invoke(this.target, event, behaviorsMethodsToExecute);
            }
            catch (Throwable _t) {
                if (_t instanceof IllegalArgumentException) {
                    IllegalArgumentException e = (IllegalArgumentException)_t;
                    String _format = MessageFormat.format(Messages.BehaviorGuardEvaluator_0, event);
                    throw new Error(_format, e);
                }
                if (_t instanceof IllegalAccessException) {
                    IllegalAccessException e_1 = (IllegalAccessException)_t;
                    String _format_1 = MessageFormat.format(Messages.BehaviorGuardEvaluator_1, event);
                    throw new Error(_format_1, e_1);
                }
                if (_t instanceof InvocationTargetException) {
                    InvocationTargetException e_2 = (InvocationTargetException)_t;
                    Throwable _cause = e_2.getCause();
                    if (_cause instanceof Error) {
                        Throwable _cause_1 = e_2.getCause();
                        throw (Error)_cause_1;
                    }
                    throw e_2;
                }
                throw Exceptions.sneakyThrow(_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }

    @Pure
    public Object getTarget() {
        return this.target;
    }

    @Pure
    public int hashCode() {
        int _hashCode = this.method.hashCode();
        int _identityHashCode = System.identityHashCode(this.target);
        return (31 + _hashCode) * 31 + _identityHashCode;
    }

    @Pure
    public boolean equals(Object obj) {
        if (obj instanceof BehaviorGuardEvaluator) {
            return this.target == ((BehaviorGuardEvaluator)obj).target && Objects.equal(this.method, ((BehaviorGuardEvaluator)obj).method);
        }
        return false;
    }

    @Pure
    public String toString() {
        String _xifexpression = null;
        _xifexpression = this.method == null ? Strings.emptyToNull(null) : this.method.getName();
        return _xifexpression;
    }
}

