/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.core;

import io.sarl.core.AgentKilled;
import io.sarl.core.AgentSpawned;
import io.sarl.core.Destroy;
import io.sarl.lang.annotation.EarlyExit;
import io.sarl.lang.annotation.FiredEvent;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacity;
import java.util.UUID;

@SarlSpecification(value="0.10")
@SarlElementType(value=20)
public interface Lifecycle
extends Capacity {
    @FiredEvent(value={AgentSpawned.class})
    public UUID spawn(Class<? extends Agent> var1, Object ... var2);

    @FiredEvent(value={AgentSpawned.class})
    public Iterable<UUID> spawn(int var1, Class<? extends Agent> var2, Object ... var3);

    @FiredEvent(value={AgentSpawned.class})
    public UUID spawnInContext(Class<? extends Agent> var1, AgentContext var2, Object ... var3);

    @FiredEvent(value={AgentSpawned.class})
    public Iterable<UUID> spawnInContext(int var1, Class<? extends Agent> var2, AgentContext var3, Object ... var4);

    @FiredEvent(value={AgentSpawned.class})
    public UUID spawnInContextWithID(Class<? extends Agent> var1, UUID var2, AgentContext var3, Object ... var4);

    @FiredEvent(value={AgentKilled.class, Destroy.class})
    @EarlyExit
    public void killMe();

    public static class ContextAwareCapacityWrapper<C extends Lifecycle>
    extends Capacity.ContextAwareCapacityWrapper<C>
    implements Lifecycle {
        public ContextAwareCapacityWrapper(C capacity, AgentTrait caller) {
            super(capacity, caller);
        }

        @Override
        public UUID spawn(Class<? extends Agent> agentType, Object ... params) {
            try {
                this.ensureCallerInLocalThread();
                UUID uUID = ((Lifecycle)this.capacity).spawn(agentType, params);
                return uUID;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Iterable<UUID> spawn(int nbAgents, Class<? extends Agent> agentType, Object ... params) {
            try {
                this.ensureCallerInLocalThread();
                Iterable<UUID> iterable = ((Lifecycle)this.capacity).spawn(nbAgents, agentType, params);
                return iterable;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public UUID spawnInContext(Class<? extends Agent> agentClass, AgentContext context, Object ... params) {
            try {
                this.ensureCallerInLocalThread();
                UUID uUID = ((Lifecycle)this.capacity).spawnInContext(agentClass, context, params);
                return uUID;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Iterable<UUID> spawnInContext(int nbAgents, Class<? extends Agent> agentClass, AgentContext context, Object ... params) {
            try {
                this.ensureCallerInLocalThread();
                Iterable<UUID> iterable = ((Lifecycle)this.capacity).spawnInContext(nbAgents, agentClass, context, params);
                return iterable;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public UUID spawnInContextWithID(Class<? extends Agent> agentClass, UUID agentID, AgentContext context, Object ... params) {
            try {
                this.ensureCallerInLocalThread();
                UUID uUID = ((Lifecycle)this.capacity).spawnInContextWithID(agentClass, agentID, context, params);
                return uUID;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void killMe() {
            try {
                this.ensureCallerInLocalThread();
                ((Lifecycle)this.capacity).killMe();
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }
    }
}

