/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.core;

import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.util.SynchronizedIterable;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.10")
@SarlElementType(value=20)
public interface InnerContextAccess
extends Capacity {
    @Pure
    public AgentContext getInnerContext();

    @Pure
    public boolean hasMemberAgent();

    @Pure
    public int getMemberAgentCount();

    @Pure
    public SynchronizedIterable<UUID> getMemberAgents();

    @Pure
    public boolean isInnerDefaultSpace(Space var1);

    @Pure
    public boolean isInnerDefaultSpace(SpaceID var1);

    @Pure
    public boolean isInnerDefaultSpace(UUID var1);

    @Pure
    public boolean isInInnerDefaultSpace(Event var1);

    public static class ContextAwareCapacityWrapper<C extends InnerContextAccess>
    extends Capacity.ContextAwareCapacityWrapper<C>
    implements InnerContextAccess {
        public ContextAwareCapacityWrapper(C capacity, AgentTrait caller) {
            super(capacity, caller);
        }

        @Override
        public AgentContext getInnerContext() {
            try {
                this.ensureCallerInLocalThread();
                AgentContext agentContext = ((InnerContextAccess)this.capacity).getInnerContext();
                return agentContext;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean hasMemberAgent() {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((InnerContextAccess)this.capacity).hasMemberAgent();
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public int getMemberAgentCount() {
            try {
                this.ensureCallerInLocalThread();
                int n = ((InnerContextAccess)this.capacity).getMemberAgentCount();
                return n;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public SynchronizedIterable<UUID> getMemberAgents() {
            try {
                this.ensureCallerInLocalThread();
                SynchronizedIterable<UUID> synchronizedIterable = ((InnerContextAccess)this.capacity).getMemberAgents();
                return synchronizedIterable;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isInnerDefaultSpace(Space space) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((InnerContextAccess)this.capacity).isInnerDefaultSpace(space);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isInnerDefaultSpace(SpaceID spaceID) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((InnerContextAccess)this.capacity).isInnerDefaultSpace(spaceID);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isInnerDefaultSpace(UUID spaceID) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((InnerContextAccess)this.capacity).isInnerDefaultSpace(spaceID);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isInInnerDefaultSpace(Event event) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((InnerContextAccess)this.capacity).isInInnerDefaultSpace(event);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }
    }
}

