/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.core;

import io.sarl.core.ContextJoined;
import io.sarl.core.ContextLeft;
import io.sarl.core.MemberJoined;
import io.sarl.core.MemberLeft;
import io.sarl.lang.annotation.DefaultValue;
import io.sarl.lang.annotation.DefaultValueSource;
import io.sarl.lang.annotation.DefaultValueUse;
import io.sarl.lang.annotation.FiredEvent;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSourceCode;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.Scope;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.util.SynchronizedIterable;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.10")
@SarlElementType(value=20)
public interface ExternalContextAccess
extends Capacity {
    @SyntheticMember
    @SarlSourceCode(value="null")
    public static final Scope $DEFAULT_VALUE$EMIT_0 = null;

    @Pure
    public SynchronizedIterable<AgentContext> getAllContexts();

    @Pure
    public AgentContext getContext(UUID var1);

    @Pure
    public AgentContext getUniverseContext();

    @FiredEvent(value={ContextJoined.class, MemberJoined.class})
    public boolean join(UUID var1, UUID var2);

    @FiredEvent(value={ContextLeft.class, MemberLeft.class})
    public boolean leave(UUID var1);

    @Pure
    public boolean isInSpace(Event var1, Space var2);

    @Pure
    public boolean isInSpace(Event var1, SpaceID var2);

    @Pure
    public boolean isInSpace(Event var1, UUID var2);

    @DefaultValueSource
    public void emit(EventSpace var1, Event var2, @DefaultValue(value="io.sarl.core.ExternalContextAccess#EMIT_0") Scope<Address> var3);

    @DefaultValueUse(value="io.sarl.lang.core.EventSpace,io.sarl.lang.core.Event,io.sarl.lang.core.Scope<io.sarl.lang.core.Address>")
    @SyntheticMember
    default public void emit(EventSpace space, Event event) {
        this.emit(space, event, $DEFAULT_VALUE$EMIT_0);
    }

    public static class ContextAwareCapacityWrapper<C extends ExternalContextAccess>
    extends Capacity.ContextAwareCapacityWrapper<C>
    implements ExternalContextAccess {
        public ContextAwareCapacityWrapper(C capacity, AgentTrait caller) {
            super(capacity, caller);
        }

        @Override
        public SynchronizedIterable<AgentContext> getAllContexts() {
            try {
                this.ensureCallerInLocalThread();
                SynchronizedIterable<AgentContext> synchronizedIterable = ((ExternalContextAccess)this.capacity).getAllContexts();
                return synchronizedIterable;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public AgentContext getContext(UUID contextID) {
            try {
                this.ensureCallerInLocalThread();
                AgentContext agentContext = ((ExternalContextAccess)this.capacity).getContext(contextID);
                return agentContext;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public AgentContext getUniverseContext() {
            try {
                this.ensureCallerInLocalThread();
                AgentContext agentContext = ((ExternalContextAccess)this.capacity).getUniverseContext();
                return agentContext;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean join(UUID contextID, UUID expectedDefaultSpaceID) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((ExternalContextAccess)this.capacity).join(contextID, expectedDefaultSpaceID);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean leave(UUID contextID) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((ExternalContextAccess)this.capacity).leave(contextID);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isInSpace(Event event, Space space) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((ExternalContextAccess)this.capacity).isInSpace(event, space);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isInSpace(Event event, SpaceID spaceID) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((ExternalContextAccess)this.capacity).isInSpace(event, spaceID);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isInSpace(Event event, UUID spaceID) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((ExternalContextAccess)this.capacity).isInSpace(event, spaceID);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void emit(EventSpace space, Event event, Scope<Address> scope) {
            try {
                this.ensureCallerInLocalThread();
                ((ExternalContextAccess)this.capacity).emit(space, event, scope);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void emit(EventSpace space, Event event) {
            try {
                this.ensureCallerInLocalThread();
                ((ExternalContextAccess)this.capacity).emit(space, event);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }
    }
}

