/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.core;

import io.sarl.core.AgentSpawned;
import io.sarl.lang.annotation.DefaultValue;
import io.sarl.lang.annotation.DefaultValueSource;
import io.sarl.lang.annotation.DefaultValueUse;
import io.sarl.lang.annotation.FiredEvent;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSourceCode;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.Scope;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.10")
@SarlElementType(value=20)
public interface DefaultContextInteractions
extends Capacity {
    @SyntheticMember
    @SarlSourceCode(value="null")
    public static final Scope $DEFAULT_VALUE$EMIT_0 = null;

    @Pure
    public AgentContext getDefaultContext();

    @Pure
    public EventSpace getDefaultSpace();

    @Pure
    public Address getDefaultAddress();

    @DefaultValueSource
    public void emit(Event var1, @DefaultValue(value="io.sarl.core.DefaultContextInteractions#EMIT_0") Scope<Address> var2);

    @Deprecated
    @Inline(value="willReceive($1, $2)")
    public void receive(UUID var1, Event var2);

    public void willReceive(UUID var1, Event var2);

    @Pure
    public boolean isDefaultSpace(Space var1);

    @Pure
    public boolean isDefaultSpace(SpaceID var1);

    @Pure
    public boolean isDefaultSpace(UUID var1);

    @Pure
    public boolean isInDefaultSpace(Event var1);

    @Pure
    public boolean isDefaultContext(AgentContext var1);

    @Pure
    public boolean isDefaultContext(UUID var1);

    @Deprecated
    @FiredEvent(value={AgentSpawned.class})
    public UUID spawn(Class<? extends Agent> var1, Object ... var2);

    @DefaultValueUse(value="io.sarl.lang.core.Event,io.sarl.lang.core.Scope<io.sarl.lang.core.Address>")
    @SyntheticMember
    default public void emit(Event event) {
        this.emit(event, $DEFAULT_VALUE$EMIT_0);
    }

    public static class ContextAwareCapacityWrapper<C extends DefaultContextInteractions>
    extends Capacity.ContextAwareCapacityWrapper<C>
    implements DefaultContextInteractions {
        public ContextAwareCapacityWrapper(C capacity, AgentTrait caller) {
            super(capacity, caller);
        }

        @Override
        public AgentContext getDefaultContext() {
            try {
                this.ensureCallerInLocalThread();
                AgentContext agentContext = ((DefaultContextInteractions)this.capacity).getDefaultContext();
                return agentContext;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public EventSpace getDefaultSpace() {
            try {
                this.ensureCallerInLocalThread();
                EventSpace eventSpace = ((DefaultContextInteractions)this.capacity).getDefaultSpace();
                return eventSpace;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Address getDefaultAddress() {
            try {
                this.ensureCallerInLocalThread();
                Address address = ((DefaultContextInteractions)this.capacity).getDefaultAddress();
                return address;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void emit(Event event, Scope<Address> scope) {
            try {
                this.ensureCallerInLocalThread();
                ((DefaultContextInteractions)this.capacity).emit(event, scope);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void receive(UUID receiver, Event event) {
            try {
                this.ensureCallerInLocalThread();
                ((DefaultContextInteractions)this.capacity).receive(receiver, event);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void willReceive(UUID receiver, Event event) {
            try {
                this.ensureCallerInLocalThread();
                ((DefaultContextInteractions)this.capacity).willReceive(receiver, event);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isDefaultSpace(Space space) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((DefaultContextInteractions)this.capacity).isDefaultSpace(space);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isDefaultSpace(SpaceID space) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((DefaultContextInteractions)this.capacity).isDefaultSpace(space);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isDefaultSpace(UUID space) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((DefaultContextInteractions)this.capacity).isDefaultSpace(space);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isInDefaultSpace(Event event) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((DefaultContextInteractions)this.capacity).isInDefaultSpace(event);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isDefaultContext(AgentContext context) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((DefaultContextInteractions)this.capacity).isDefaultContext(context);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isDefaultContext(UUID contextID) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((DefaultContextInteractions)this.capacity).isDefaultContext(contextID);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public UUID spawn(Class<? extends Agent> agentType, Object ... params) {
            try {
                this.ensureCallerInLocalThread();
                UUID uUID = ((DefaultContextInteractions)this.capacity).spawn(agentType, params);
                return uUID;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void emit(Event event) {
            try {
                this.ensureCallerInLocalThread();
                ((DefaultContextInteractions)this.capacity).emit(event);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }
    }
}

