/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.core;

import io.sarl.lang.annotation.DefaultValue;
import io.sarl.lang.annotation.DefaultValueSource;
import io.sarl.lang.annotation.DefaultValueUse;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSourceCode;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Behavior;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.core.Scope;
import io.sarl.lang.util.SynchronizedIterable;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.10")
@SarlElementType(value=20)
public interface Behaviors
extends Capacity {
    @SyntheticMember
    @SarlSourceCode(value="null")
    public static final Functions.Function1 $DEFAULT_VALUE$REGISTERBEHAVIOR_0 = null;
    @SyntheticMember
    @SarlSourceCode(value="null")
    public static final Scope $DEFAULT_VALUE$WAKE_0 = null;

    public boolean hasRegisteredBehavior();

    public SynchronizedIterable<Behavior> getRegisteredBehaviors();

    @DefaultValueSource
    public Behavior registerBehavior(Behavior var1, @DefaultValue(value="io.sarl.core.Behaviors#REGISTERBEHAVIOR_0") Functions.Function1<? super Event, ? extends Boolean> var2, Object ... var3);

    public Behavior unregisterBehavior(Behavior var1);

    @DefaultValueSource
    public void wake(Event var1, @DefaultValue(value="io.sarl.core.Behaviors#WAKE_0") Scope<Address> var2);

    @Pure
    public EventListener asEventListener();

    @DefaultValueUse(value="io.sarl.lang.core.Behavior,(io.sarl.lang.core.Event)=>boolean,java.lang.Object*")
    @SyntheticMember
    default public Behavior registerBehavior(Behavior attitude, Object ... initializationParameters) {
        return this.registerBehavior(attitude, $DEFAULT_VALUE$REGISTERBEHAVIOR_0, initializationParameters);
    }

    @DefaultValueUse(value="io.sarl.lang.core.Event,io.sarl.lang.core.Scope<io.sarl.lang.core.Address>")
    @SyntheticMember
    default public void wake(Event event) {
        this.wake(event, $DEFAULT_VALUE$WAKE_0);
    }

    public static class ContextAwareCapacityWrapper<C extends Behaviors>
    extends Capacity.ContextAwareCapacityWrapper<C>
    implements Behaviors {
        public ContextAwareCapacityWrapper(C capacity, AgentTrait caller) {
            super(capacity, caller);
        }

        @Override
        public boolean hasRegisteredBehavior() {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((Behaviors)this.capacity).hasRegisteredBehavior();
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public SynchronizedIterable<Behavior> getRegisteredBehaviors() {
            try {
                this.ensureCallerInLocalThread();
                SynchronizedIterable<Behavior> synchronizedIterable = ((Behaviors)this.capacity).getRegisteredBehaviors();
                return synchronizedIterable;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Behavior registerBehavior(Behavior attitude, Functions.Function1<? super Event, ? extends Boolean> filter, Object ... initializationParameters) {
            try {
                this.ensureCallerInLocalThread();
                Behavior behavior = ((Behaviors)this.capacity).registerBehavior(attitude, filter, initializationParameters);
                return behavior;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Behavior unregisterBehavior(Behavior attitude) {
            try {
                this.ensureCallerInLocalThread();
                Behavior behavior = ((Behaviors)this.capacity).unregisterBehavior(attitude);
                return behavior;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void wake(Event event, Scope<Address> scope) {
            try {
                this.ensureCallerInLocalThread();
                ((Behaviors)this.capacity).wake(event, scope);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public EventListener asEventListener() {
            try {
                this.ensureCallerInLocalThread();
                EventListener eventListener = ((Behaviors)this.capacity).asEventListener();
                return eventListener;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Behavior registerBehavior(Behavior attitude, Object ... initializationParameters) {
            try {
                this.ensureCallerInLocalThread();
                Behavior behavior = ((Behaviors)this.capacity).registerBehavior(attitude, initializationParameters);
                return behavior;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void wake(Event event) {
            try {
                this.ensureCallerInLocalThread();
                ((Behaviors)this.capacity).wake(event);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }
    }
}

