/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.core;

import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Event;
import io.sarl.util.concurrent.Collections3;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@SarlSpecification(value="0.10")
@SarlElementType(value=15)
public final class AgentSpawned
extends Event {
    @Deprecated
    public final UUID agentID;
    public final Collection<UUID> agentIdentifiers;
    public final String agentType;
    @SyntheticMember
    private static final long serialVersionUID = 1714216511L;

    @Deprecated
    public AgentSpawned(Address source, UUID agentID, String agentType) {
        this.setSource(source);
        this.agentIdentifiers = Collections.singleton(agentID);
        this.agentID = agentID;
        this.agentType = agentType;
    }

    public AgentSpawned(Address source, String agentType, UUID ... agentID) {
        this.setSource(source);
        this.agentIdentifiers = Collections.unmodifiableCollection(Arrays.asList(agentID));
        this.agentID = agentID[0];
        this.agentType = agentType;
    }

    public AgentSpawned(Address source, String agentType, Collection<UUID> agentID) {
        this.setSource(source);
        this.agentIdentifiers = Collections.unmodifiableCollection(Collections3.serializableCollection(agentID));
        this.agentID = agentID.iterator().next();
        this.agentType = agentType;
    }

    @Override
    @Pure
    @SyntheticMember
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgentSpawned other = (AgentSpawned)obj;
        if (!Objects.equals(this.agentID, other.agentID)) {
            return false;
        }
        if (!Objects.equals(this.agentType, other.agentType)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    @Pure
    @SyntheticMember
    public int hashCode() {
        int result = super.hashCode();
        int prime = 31;
        result = 31 * result + Objects.hashCode(this.agentID);
        result = 31 * result + Objects.hashCode(this.agentType);
        return result;
    }

    @Override
    @SyntheticMember
    @Pure
    protected void toString(ToStringBuilder builder) {
        super.toString(builder);
        builder.add("agentID", this.agentID);
        builder.add("agentIdentifiers", this.agentIdentifiers);
        builder.add("agentType", this.agentType);
    }
}

