/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.bootstrap;

import io.sarl.bootstrap.SREBootstrap;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class SRE {
    private static final String PREFIX = "META-INF/services/";
    private static SREBootstrap currentSRE;
    private static SoftReference<ServiceLoader<SREBootstrap>> loader;

    private SRE() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetServiceLoader() {
        Class<SRE> clazz = SRE.class;
        synchronized (SRE.class) {
            loader = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Pure
    @Inline(value="getServiceLoader(false)")
    public static ServiceLoader<SREBootstrap> getServiceLoader() {
        return SRE.getServiceLoader(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pure
    public static ServiceLoader<SREBootstrap> getServiceLoader(boolean onlyInstalledInJRE) {
        Class<SRE> clazz = SRE.class;
        synchronized (SRE.class) {
            ServiceLoader<SREBootstrap> sl;
            ServiceLoader<SREBootstrap> serviceLoader = sl = loader == null ? null : loader.get();
            if (sl == null) {
                sl = onlyInstalledInJRE ? ServiceLoader.loadInstalled(SREBootstrap.class) : ServiceLoader.load(SREBootstrap.class);
                loader = new SoftReference<ServiceLoader<SREBootstrap>>(sl);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sl;
        }
    }

    @Pure
    public static Set<URL> getBootstrappedLibraries() {
        String name = PREFIX + SREBootstrap.class.getName();
        TreeSet<URL> result = new TreeSet<URL>();
        try {
            Enumeration<URL> enumr = ClassLoader.getSystemResources(name);
            while (enumr.hasMoreElements()) {
                URL url = enumr.nextElement();
                if (url == null) continue;
                result.add(url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBootstrap(SREBootstrap sre) {
        Class<SRE> clazz = SRE.class;
        synchronized (SRE.class) {
            currentSRE = sre;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        Object[] params = new Object[args.length - 1];
        if (args.length > 1) {
            System.arraycopy(args, 1, params, 0, params.length);
        }
        Class<?> type = Class.forName(args[0]);
        SRE.getBootstrap().startAgent(type, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pure
    public static SREBootstrap getBootstrap() {
        Class<SRE> clazz = SRE.class;
        synchronized (SRE.class) {
            if (currentSRE == null) {
                Iterator<SREBootstrap> iterator = SRE.getServiceLoader().iterator();
                currentSRE = iterator.hasNext() ? iterator.next() : new VoidSREBootstrap();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentSRE;
        }
    }

    private static class VoidSREBootstrap
    implements SREBootstrap {
        VoidSREBootstrap() {
        }

        @Override
        public AgentContext startWithoutAgent() {
            return null;
        }

        @Override
        public UUID startAgent(Class<? extends Agent> agentCls, Object ... params) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<UUID> startAgent(int nbAgents, Class<? extends Agent> agentCls, Object ... params) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void startAgentWithID(Class<? extends Agent> agentCls, UUID agentID, Object ... params) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public UUID getBootAgentIdentifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public boolean isRunning() {
            return false;
        }

        @Override
        public void shutdown(boolean blocking) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T getService(Class<T> serviceType) {
            return null;
        }
    }
}

