/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.util;

import io.janusproject.JanusConfig;
import java.io.PrintStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public final class LoggerCreator {
    private static final String FORMAT_PROPERTY_KEY = "java.util.logging.SimpleFormatter.format";
    private static final String JANUS_FORMAT = "[%4$s, %1$tl:%1$tM:%1$tS%1$tp, %3$s] %5$s%6$s%n";
    private static Level levelFromProperties;

    private LoggerCreator() {
    }

    public static void useJanusMessageFormat() {
        String format = System.getProperty(FORMAT_PROPERTY_KEY, null);
        if (format == null || format.isEmpty()) {
            System.setProperty(FORMAT_PROPERTY_KEY, JANUS_FORMAT);
        }
    }

    public static Logger createPlatformLogger() {
        Logger logger = Logger.getAnonymousLogger();
        Handler[] handlerArray = logger.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            logger.removeHandler(handler);
            ++n2;
        }
        StandardErrorOutputConsoleHandler stderr = new StandardErrorOutputConsoleHandler();
        stderr.setLevel(Level.ALL);
        StandardOutputConsoleHandler stdout = new StandardOutputConsoleHandler();
        stdout.setLevel(Level.ALL);
        logger.addHandler(stderr);
        logger.addHandler(stdout);
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.ALL);
        return logger;
    }

    public static Logger createModuleLogger(String name, Logger parent) {
        Logger logger = Logger.getLogger(name);
        if (parent != null) {
            logger.setParent(parent);
        }
        logger.setUseParentHandlers(true);
        Level level = LoggerCreator.getLoggingLevelFromProperties();
        logger.setLevel(level);
        return logger;
    }

    public static Level getLoggingLevelFromProperties() {
        if (levelFromProperties == null) {
            String verboseLevel = JanusConfig.getSystemProperty("janus.verbose.level", "info");
            levelFromProperties = LoggerCreator.parseLoggingLevel(verboseLevel);
        }
        return levelFromProperties;
    }

    public static Level parseLoggingLevel(String level) {
        if (level == null) {
            return Level.INFO;
        }
        switch (level.toLowerCase()) {
            case "0": 
            case "none": 
            case "false": {
                return Level.OFF;
            }
            case "severe": 
            case "1": 
            case "error": {
                return Level.SEVERE;
            }
            case "2": 
            case "warn": 
            case "warning": {
                return Level.WARNING;
            }
            case "3": 
            case "info": 
            case "true": {
                return Level.INFO;
            }
            case "config": 
            case "4": 
            case "fine": {
                return Level.FINE;
            }
            case "5": 
            case "finer": {
                return Level.FINER;
            }
            case "finest": 
            case "6": 
            case "debug": {
                return Level.FINEST;
            }
            case "7": 
            case "all": {
                return Level.ALL;
            }
        }
        try {
            return LoggerCreator.fromInt(Integer.parseInt(level));
        }
        catch (Throwable throwable) {
            return Level.INFO;
        }
    }

    public static Level fromInt(int num) {
        switch (num) {
            case 0: {
                return Level.OFF;
            }
            case 1: {
                return Level.SEVERE;
            }
            case 2: {
                return Level.WARNING;
            }
            case 3: {
                return Level.INFO;
            }
            case 4: {
                return Level.FINE;
            }
            case 5: {
                return Level.FINER;
            }
            case 6: {
                return Level.FINEST;
            }
            case 7: {
                return Level.ALL;
            }
        }
        if (num < 0) {
            return Level.OFF;
        }
        return Level.ALL;
    }

    public static int toInt(Level level) {
        if (level == Level.OFF) {
            return 0;
        }
        if (level == Level.SEVERE) {
            return 1;
        }
        if (level == Level.WARNING) {
            return 2;
        }
        if (level == Level.INFO) {
            return 3;
        }
        if (level == Level.CONFIG) {
            return 4;
        }
        if (level == Level.FINE) {
            return 4;
        }
        if (level == Level.FINER) {
            return 5;
        }
        if (level == Level.FINEST) {
            return 6;
        }
        if (level == Level.ALL) {
            return 7;
        }
        return 3;
    }

    public static int toInt(String level) {
        return LoggerCreator.toInt(LoggerCreator.parseLoggingLevel(level));
    }

    public static String[] getLevelStrings() {
        return new String[]{"none", "error", "warning", "info", "fine", "finer", "finest", "all"};
    }

    public static abstract class AbstractStandardConsoleHandler
    extends StreamHandler {
        public AbstractStandardConsoleHandler(PrintStream stream) {
            super(stream, new SimpleFormatter());
        }

        @Override
        public synchronized void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }

        @Override
        public synchronized void close() {
            this.flush();
        }

        protected abstract boolean isLoggable(int var1);

        @Override
        public boolean isLoggable(LogRecord record) {
            if (record != null) {
                Level level = record.getLevel();
                assert (level != null);
                if (this.isLoggable(level.intValue())) {
                    return super.isLoggable(record);
                }
            }
            return false;
        }
    }

    public static class StandardErrorOutputConsoleHandler
    extends AbstractStandardConsoleHandler {
        public StandardErrorOutputConsoleHandler() {
            super(System.err);
        }

        @Override
        public boolean isLoggable(int level) {
            return level >= Level.WARNING.intValue();
        }
    }

    public static class StandardOutputConsoleHandler
    extends AbstractStandardConsoleHandler {
        public StandardOutputConsoleHandler() {
            super(System.out);
        }

        @Override
        public boolean isLoggable(int level) {
            return level < Level.WARNING.intValue();
        }
    }
}

