/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.util;

import io.janusproject.services.distributeddata.DMapListener;
import io.janusproject.util.ListenerCollection;

public abstract class AbstractMapView<K, V> {
    protected final ListenerCollection<DMapListener<? super K, ? super V>> listeners = new ListenerCollection();

    protected void fireEntryAdded(K key, V value) {
        if (this.listeners != null) {
            DMapListener[] dMapListenerArray = (DMapListener[])this.listeners.getListeners(DMapListener.class);
            int n = dMapListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DMapListener listener = dMapListenerArray[n2];
                listener.entryAdded(key, value);
                ++n2;
            }
        }
    }

    protected void fireEntryRemoved(K key, V value) {
        if (this.listeners != null) {
            DMapListener[] dMapListenerArray = (DMapListener[])this.listeners.getListeners(DMapListener.class);
            int n = dMapListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DMapListener listener = dMapListenerArray[n2];
                listener.entryRemoved(key, value);
                ++n2;
            }
        }
    }

    protected void fireEntryUpdated(K key, V value) {
        DMapListener[] dMapListenerArray = (DMapListener[])this.listeners.getListeners(DMapListener.class);
        int n = dMapListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DMapListener listener = dMapListenerArray[n2];
            listener.entryUpdated(key, value);
            ++n2;
        }
    }

    protected void fireCleared(boolean localClearing) {
        DMapListener[] dMapListenerArray = (DMapListener[])this.listeners.getListeners(DMapListener.class);
        int n = dMapListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DMapListener listener = dMapListenerArray[n2];
            listener.mapCleared(localClearing);
            ++n2;
        }
    }

    public void addDMapListener(DMapListener<? super K, ? super V> listener) {
        this.listeners.add(DMapListener.class, listener);
    }

    public void removeDMapListener(DMapListener<? super K, ? super V> listener) {
        this.listeners.remove(DMapListener.class, listener);
    }
}

