/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.services.executor;

import io.janusproject.services.executor.EarlyExitException;
import java.util.concurrent.Callable;

public class JanusCallable<T>
implements Callable<T> {
    private final Callable<T> callable;

    public JanusCallable(Callable<T> callable) {
        assert (callable != null);
        this.callable = callable;
    }

    public Callable<T> getWrappedCallable() {
        return this.callable;
    }

    @Override
    public T call() throws Exception {
        return this.callWithEarlyExitSupport();
    }

    protected final T callWithEarlyExitSupport() throws Exception {
        try {
            return this.callable.call();
        }
        catch (EarlyExitException e) {
            return null;
        }
    }

    public String toString() {
        return this.callable.toString();
    }

    public boolean equals(Object obj) {
        return this.callable.equals(obj);
    }

    public int hashCode() {
        return this.callable.hashCode();
    }
}

