/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.modules.hazelcast;

import com.hazelcast.logging.AbstractLogger;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LoggerFactorySupport;
import io.janusproject.services.logging.LogService;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class HazelcastKernelLoggerFactory
extends LoggerFactorySupport {
    private static LogService logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogService getLogService() {
        Class<HazelcastKernelLoggerFactory> clazz = HazelcastKernelLoggerFactory.class;
        synchronized (HazelcastKernelLoggerFactory.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogService(LogService service) {
        Class<HazelcastKernelLoggerFactory> clazz = HazelcastKernelLoggerFactory.class;
        synchronized (HazelcastKernelLoggerFactory.class) {
            logger = service;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected ILogger createLogger(String name) {
        return new HzKernelLogger();
    }

    private static final class HzKernelLogger
    extends AbstractLogger {
        HzKernelLogger() {
        }

        @Override
        public void log(Level level, String message) {
            Logger log;
            LogService serv = HazelcastKernelLoggerFactory.getLogService();
            if (serv != null && (log = serv.getKernelLogger()) != null) {
                log.log(new LogRecord(level, message));
            }
        }

        @Override
        public void log(Level level, String message, Throwable thrown) {
            LogService serv = HazelcastKernelLoggerFactory.getLogService();
            if (serv != null && serv.getKernelLogger().isLoggable(level)) {
                StackTraceElement elt = HzKernelLogger.getCaller();
                assert (elt != null);
                LogRecord record = new LogRecord(level, message);
                if (thrown != null) {
                    record.setThrown(thrown);
                }
                record.setSourceClassName(elt.getClassName());
                record.setSourceMethodName(elt.getMethodName());
                serv.getKernelLogger().log(record);
            }
        }

        @Override
        public void log(LogEvent logEvent) {
            LogService serv = HazelcastKernelLoggerFactory.getLogService();
            if (serv != null) {
                serv.getKernelLogger().log(logEvent.getLogRecord());
            }
        }

        @Override
        public Level getLevel() {
            LogService serv = HazelcastKernelLoggerFactory.getLogService();
            if (serv != null) {
                return serv.getKernelLogger().getLevel();
            }
            return Level.OFF;
        }

        @Override
        public boolean isLoggable(Level level) {
            LogService serv = HazelcastKernelLoggerFactory.getLogService();
            if (serv != null) {
                return serv.getKernelLogger().isLoggable(level);
            }
            return false;
        }

        private static StackTraceElement getCaller() {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int i = 1;
            while (i < stackTrace.length) {
                try {
                    Class<?> type = Class.forName(stackTrace[i].getClassName());
                    if (type != null && !ILogger.class.isAssignableFrom(type)) {
                        return stackTrace[i];
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                ++i;
            }
            return null;
        }
    }
}

