/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.modules;

import com.google.common.util.concurrent.Service;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import io.janusproject.kernel.services.jdk.contextspace.StandardContextSpaceService;
import io.janusproject.kernel.services.jdk.logging.StandardLogService;
import io.janusproject.kernel.services.jdk.spawn.StandardSpawnService;
import io.janusproject.modules.executors.JdkExecutorModule;
import io.janusproject.modules.kernel.MandatoryKernelModule;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.kerneldiscovery.KernelDiscoveryService;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.network.NetworkService;
import io.janusproject.services.spawn.SpawnService;
import io.janusproject.util.LoggerCreator;
import io.sarl.util.concurrent.LockModule;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Logger;

public class StandardCoreModule
extends AbstractModule {
    @Override
    protected void configure() {
        LoggerCreator.useJanusMessageFormat();
        this.bindListener(Matchers.any(), new LoggerMemberListener());
        this.bind(LogService.class).to(StandardLogService.class).in(Singleton.class);
        this.bind(ContextSpaceService.class).to(StandardContextSpaceService.class).in(Singleton.class);
        this.bind(SpawnService.class).to(StandardSpawnService.class).in(Singleton.class);
        this.install(new LockModule());
        this.install(new JdkExecutorModule());
        this.install(new MandatoryKernelModule());
        this.requireBinding(DistributedDataStructureService.class);
        this.requireBinding(KernelDiscoveryService.class);
        this.requireBinding(ExecutorService.class);
        this.requireBinding(ContextSpaceService.class);
        this.requireBinding(Logger.class);
        this.requireBinding(LogService.class);
        this.requireBinding(NetworkService.class);
        this.requireBinding(SpawnService.class);
        Multibinder<Service> serviceSetBinder = Multibinder.newSetBinder(this.binder(), Service.class);
        serviceSetBinder.addBinding().to(LogService.class);
        serviceSetBinder.addBinding().to(ExecutorService.class);
        serviceSetBinder.addBinding().to(ContextSpaceService.class);
        serviceSetBinder.addBinding().to(KernelDiscoveryService.class);
        serviceSetBinder.addBinding().to(SpawnService.class);
        serviceSetBinder.addBinding().to(DistributedDataStructureService.class);
    }

    private static final class LoggerMemberInjector<T>
    implements MembersInjector<T> {
        private final Logger rootLogger;
        private final Field field;
        private final Method method;

        LoggerMemberInjector(Logger rootLogger, Field field) {
            this.rootLogger = rootLogger;
            this.field = field;
            this.method = null;
        }

        LoggerMemberInjector(Logger rootLogger, Method method) {
            this.rootLogger = rootLogger;
            this.field = null;
            this.method = method;
        }

        @Override
        public void injectMembers(T instance) {
            boolean accessible;
            if (this.field != null) {
                accessible = this.field.isAccessible();
                try {
                    try {
                        this.field.setAccessible(true);
                        this.field.set(instance, this.rootLogger);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    this.field.setAccessible(accessible);
                }
            }
            if (this.method != null) {
                accessible = this.method.isAccessible();
                try {
                    try {
                        this.method.setAccessible(true);
                        this.method.invoke(instance, this.rootLogger);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    this.method.setAccessible(accessible);
                }
            }
        }
    }

    private static final class LoggerMemberListener
    implements TypeListener {
        private final Logger rootLogger = LoggerCreator.createPlatformLogger();

        LoggerMemberListener() {
        }

        @Override
        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            AccessibleObject[] accessibleObjectArray = type.getRawType().getDeclaredFields();
            int n = accessibleObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = accessibleObjectArray[n2];
                if (field.getType() == Logger.class && (field.isAnnotationPresent(Inject.class) || field.isAnnotationPresent(javax.inject.Inject.class))) {
                    encounter.register(new LoggerMemberInjector(this.rootLogger, field));
                }
                ++n2;
            }
            accessibleObjectArray = type.getRawType().getDeclaredMethods();
            n = accessibleObjectArray.length;
            n2 = 0;
            while (n2 < n) {
                AccessibleObject method = accessibleObjectArray[n2];
                if (Modifier.isPublic(((Method)method).getModifiers()) && ((Method)method).getParameterCount() == 1 && ((Method)method).getParameterTypes()[0].equals(Logger.class) && (method.isAnnotationPresent(Inject.class) || method.isAnnotationPresent(javax.inject.Inject.class))) {
                    encounter.register(new LoggerMemberInjector(this.rootLogger, (Method)method));
                }
                ++n2;
            }
        }
    }
}

