/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.space;

import com.google.inject.Provider;
import io.janusproject.kernel.space.AbstractEventSpace;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.core.SpaceID;
import io.sarl.util.RestrictedAccessEventSpace;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.Permission;
import java.util.concurrent.locks.ReadWriteLock;

public class RestrictedAccessEventSpaceImpl
extends AbstractEventSpace
implements RestrictedAccessEventSpace {
    private final Acl acl;
    private final Permission accessPermission;

    public RestrictedAccessEventSpaceImpl(SpaceID id, Acl acl, Permission accessPermission, DistributedDataStructureService factory, Provider<ReadWriteLock> lockProvider) {
        super(id, factory, lockProvider);
        assert (acl != null);
        assert (accessPermission != null);
        this.acl = acl;
        this.accessPermission = accessPermission;
    }

    public Acl getAcl() {
        return this.acl;
    }

    public Permission getRegistrationPermission() {
        return this.accessPermission;
    }

    @Override
    public Address register(EventListener entity, Principal principal) {
        if (this.acl.checkPermission(principal, this.accessPermission)) {
            return this.getParticipantInternalDataStructure().registerParticipant(new Address(this.getSpaceID(), entity.getID()), entity);
        }
        return null;
    }

    @Override
    public final <P extends EventListener & Principal> Address register(P entity) {
        return this.register(entity, entity);
    }

    @Override
    public Address unregister(EventListener entity) {
        return this.getParticipantInternalDataStructure().unregisterParticipant(entity);
    }
}

