/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.space;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.janusproject.kernel.space.AbstractEventSpace;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.sarl.core.OpenEventSpace;
import io.sarl.core.ParticipantJoined;
import io.sarl.core.ParticipantLeft;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.SpaceID;
import java.util.concurrent.locks.ReadWriteLock;

public class EventSpaceImpl
extends AbstractEventSpace
implements OpenEventSpace {
    private final ContextSpaceService contextRepository;

    @Inject
    public EventSpaceImpl(SpaceID id, DistributedDataStructureService factory, ContextSpaceService contextRepository, Provider<ReadWriteLock> lockProvider) {
        super(id, factory, lockProvider);
        this.contextRepository = contextRepository;
    }

    @Override
    public Address register(EventListener entity) {
        Address a = this.getParticipantInternalDataStructure().registerParticipant(new Address(this.getSpaceID(), entity.getID()), entity);
        this.fireParticipantJoined(a);
        return a;
    }

    @Override
    public Address unregister(EventListener entity) {
        Address a = this.getParticipantInternalDataStructure().unregisterParticipant(entity);
        this.fireParticipantLeft(a);
        return a;
    }

    protected final void fireParticipantJoined(Address newAgentAddress) {
        AgentContext enclosingContext = this.contextRepository.getContext(newAgentAddress.getSpaceID().getContextID());
        EventSpace defSpace = enclosingContext.getDefaultSpace();
        defSpace.emit(null, new ParticipantJoined(new Address(defSpace.getSpaceID(), newAgentAddress.getUUID()), newAgentAddress.getSpaceID()), it -> !it.getUUID().equals(newAgentAddress.getUUID()));
    }

    protected final void fireParticipantLeft(Address agentAddress) {
        AgentContext enclosingContext = this.contextRepository.getContext(agentAddress.getSpaceID().getContextID());
        EventSpace defSpace = enclosingContext.getDefaultSpace();
        defSpace.emit(null, new ParticipantLeft(new Address(defSpace.getSpaceID(), agentAddress.getUUID()), agentAddress.getSpaceID()), it -> !it.getUUID().equals(agentAddress.getUUID()));
    }
}

