/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.space;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.janusproject.kernel.repository.UniqueAddressParticipantRepository;
import io.janusproject.kernel.space.Messages;
import io.janusproject.kernel.space.SpaceBase;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.network.NetworkService;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.core.Scope;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.util.Scopes;
import io.sarl.util.concurrent.Collections3;
import java.text.MessageFormat;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;

public abstract class AbstractEventSpace
extends SpaceBase {
    @Inject
    protected LogService logger;
    @Inject
    protected ExecutorService executorService;
    @Inject
    private NetworkService network;
    private final UniqueAddressParticipantRepository<Address> participants;

    public AbstractEventSpace(SpaceID id, DistributedDataStructureService factory, Provider<ReadWriteLock> lockProvider) {
        super(id);
        this.participants = new UniqueAddressParticipantRepository(String.valueOf(this.getSpaceID().getID().toString()) + "-participants", factory, lockProvider);
    }

    protected UniqueAddressParticipantRepository<Address> getParticipantInternalDataStructure() {
        return this.participants;
    }

    public final Address getAddress(EventListener entity) {
        return this.getAddress(entity.getID());
    }

    public Address getAddress(UUID id) {
        return this.getParticipantInternalDataStructure().getAddress(id);
    }

    public final void emit(UUID eventSource, Event event, Scope<Address> scope) {
        assert (event != null);
        this.ensureEventSource(eventSource, event);
        assert (this.getSpaceID().equals(event.getSource().getSpaceID())) : "The source address must belong to this space";
        try {
            Scope<Object> scopeInstance = scope == null ? Scopes.allParticipants() : scope;
            try {
                this.network.publish(scopeInstance, event);
            }
            catch (Throwable e) {
                this.logger.getKernelLogger().severe(MessageFormat.format(Messages.AbstractEventSpace_2, event, scope, e));
            }
            this.doEmit(event, scopeInstance);
        }
        catch (Throwable e) {
            this.logger.getKernelLogger().severe(MessageFormat.format(Messages.AbstractEventSpace_0, event, scope, e));
        }
    }

    protected void ensureEventSource(UUID eventSource, Event event) {
        if (event.getSource() == null) {
            if (eventSource != null) {
                event.setSource(new Address(this.getSpaceID(), eventSource));
            } else {
                throw new AssertionError((Object)"Every event must have a source");
            }
        }
    }

    protected void doEmit(Event event, Scope<? super Address> scope) {
        assert (scope != null);
        assert (event != null);
        UniqueAddressParticipantRepository<Address> particips = this.getParticipantInternalDataStructure();
        SynchronizedCollection<EventListener> listeners = particips.getListeners();
        ReadWriteLock lock = listeners.getLock();
        lock.readLock().lock();
        try {
            for (EventListener listener : listeners) {
                Address adr = this.getAddress(listener);
                if (!scope.matches(adr)) continue;
                this.executorService.submit(new AsyncRunner(listener, event));
            }
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Override
    public SynchronizedSet<UUID> getParticipants() {
        return Collections3.unmodifiableSynchronizedSet(this.getParticipantInternalDataStructure().getParticipantIDs());
    }

    public String toString() {
        return this.getSpaceID().toString();
    }

    @Override
    public void eventReceived(SpaceID space, Scope<?> scope, Event event) {
        try {
            this.doEmit(event, scope);
        }
        catch (Exception e) {
            this.logger.getKernelLogger().severe(MessageFormat.format(Messages.AbstractEventSpace_1, e));
        }
    }

    private static class AsyncRunner
    implements Runnable {
        private final EventListener agent;
        private final Event event;

        AsyncRunner(EventListener agent, Event event) {
            this.agent = agent;
            this.event = event;
        }

        @Override
        public void run() {
            this.agent.receiveEvent(this.event);
        }

        public String toString() {
            return "[agent=" + this.agent + "; event=" + this.event + "]";
        }
    }
}

