/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.spawn;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Service;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.janusproject.kernel.bic.BuiltinCapacityUtil;
import io.janusproject.kernel.services.jdk.spawn.Messages;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.spawn.KernelAgentSpawnListener;
import io.janusproject.services.spawn.SpawnService;
import io.janusproject.services.spawn.SpawnServiceListener;
import io.janusproject.util.ListenerCollection;
import io.sarl.core.AgentKilled;
import io.sarl.core.AgentSpawned;
import io.sarl.core.Logging;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.BuiltinCapacitiesProvider;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.SREutils;
import io.sarl.lang.core.Scope;
import io.sarl.lang.util.SynchronizedIterable;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.sarlspecification.SarlSpecificationChecker;
import io.sarl.util.concurrent.Collections3;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class StandardSpawnService
extends AbstractDependentService
implements SpawnService {
    private static final int CREATION_POOL_SIZE = 128;
    private final ListenerCollection<?> globalListeners = new ListenerCollection();
    private final Map<UUID, ListenerCollection<SpawnServiceListener>> agentLifecycleListeners = new TreeMap<UUID, ListenerCollection<SpawnServiceListener>>();
    private ReadWriteLock agentLifecycleListenersLock;
    private final Map<UUID, Agent> agents = new TreeMap<UUID, Agent>();
    private ReadWriteLock agentsLock;
    private final Injector injector;
    private final SarlSpecificationChecker sarlSpecificationChecker;
    @Inject
    private ExecutorService executor;
    @Inject
    private LogService logger;
    @Inject
    private BuiltinCapacitiesProvider builtinCapacityProvider;

    @Inject
    public StandardSpawnService(Injector injector, SarlSpecificationChecker sarlSpecificationChecker) {
        this.injector = injector;
        Provider<ReadWriteLock> provider = this.injector.getProvider(ReadWriteLock.class);
        this.agentLifecycleListenersLock = provider.get();
        this.agentsLock = provider.get();
        this.sarlSpecificationChecker = sarlSpecificationChecker;
    }

    protected final ReadWriteLock getAgentRepositoryLock() {
        return this.agentsLock;
    }

    protected final ReadWriteLock getAgentLifecycleListenerLock() {
        return this.agentLifecycleListenersLock;
    }

    @Override
    public final Class<? extends Service> getServiceType() {
        return SpawnService.class;
    }

    @Override
    public Collection<Class<? extends Service>> getServiceDependencies() {
        return Arrays.asList(ContextSpaceService.class);
    }

    private void ensureSarlSpecificationVersion(Class<? extends Agent> agentClazz) {
        if (!this.sarlSpecificationChecker.isValidSarlElement(agentClazz)) {
            throw new InvalidSarlSpecificationException(agentClazz);
        }
    }

    @Override
    public List<UUID> spawn(int nbAgents, UUID spawningAgent, AgentContext parent, UUID agentID, Class<? extends Agent> agentClazz, Object ... params) {
        if (this.isRunning() && nbAgents > 0) {
            try {
                this.ensureSarlSpecificationVersion(agentClazz);
                JustInTimeAgentInjectionModule agentInjectionModule = new JustInTimeAgentInjectionModule(agentClazz, parent.getID(), agentID);
                Injector agentInjector = this.injector.createChildInjector(agentInjectionModule);
                ArrayList<Agent> agents = new ArrayList<Agent>(nbAgents);
                Runnable agentCreator = () -> {
                    Agent agent = agentInjector.getInstance(Agent.class);
                    assert (agent != null);
                    this.builtinCapacityProvider.builtinCapacities(agent, (capacity, skill) -> {
                        try {
                            SREutils.createSkillMapping(agent, capacity, skill);
                        }
                        catch (Exception e) {
                            throw new Error(Messages.StandardSpawnService_5, e);
                        }
                    });
                    ReadWriteLock lock = this.getAgentRepositoryLock();
                    lock.writeLock().lock();
                    try {
                        this.agents.put(agent.getID(), agent);
                    }
                    finally {
                        lock.writeLock().unlock();
                    }
                    List list2 = agents;
                    synchronized (list2) {
                        agents.add(agent);
                    }
                    this.fireAgentSpawnedInAgent(spawningAgent, parent, agent, params);
                };
                if (nbAgents > 1) {
                    this.executor.executeMultipleTimesInParallelAndWaitForTermination(agentCreator, nbAgents, 128);
                } else {
                    agentCreator.run();
                }
                this.fireAgentSpawnedOutsideAgent(spawningAgent, parent, agentClazz, agents, params);
                return Collections.unmodifiableList(Lists.transform(agents, it -> it.getID()));
            }
            catch (Throwable e) {
                throw new CannotSpawnException(agentClazz, e);
            }
        }
        throw new SpawnDisabledException(parent.getID(), agentClazz);
    }

    protected void fireAgentSpawnedOutsideAgent(UUID spawningAgent, AgentContext context, Class<? extends Agent> agentClazz, List<Agent> agents, Object ... initializationParameters) {
        SpawnServiceListener[] spawnServiceListenerArray = (SpawnServiceListener[])this.globalListeners.getListeners(SpawnServiceListener.class);
        int n = spawnServiceListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpawnServiceListener l = spawnServiceListenerArray[n2];
            l.agentSpawned(spawningAgent, context, agents, initializationParameters);
            ++n2;
        }
        EventSpace defSpace = context.getDefaultSpace();
        assert (defSpace != null) : "A context does not contain a default space";
        UUID spawner = spawningAgent == null ? context.getID() : spawningAgent;
        Address source = new Address(defSpace.getSpaceID(), spawner);
        assert (source != null);
        Collection<UUID> spawnedAgentIds = Collections3.serializableCollection(Collections2.transform(agents, it -> it.getID()));
        AgentSpawned event = new AgentSpawned(source, agentClazz.getName(), spawnedAgentIds);
        Scope<Address> scope = address -> {
            UUID receiver = address.getUUID();
            return !spawnedAgentIds.parallelStream().anyMatch(it -> it.equals(receiver));
        };
        defSpace.emit(null, event, scope);
    }

    protected void fireAgentSpawnedInAgent(UUID spawningAgent, AgentContext context, Agent agent, Object ... initializationParameters) {
        ListenerCollection<SpawnServiceListener> list;
        ReadWriteLock lock = this.getAgentLifecycleListenerLock();
        lock.readLock().lock();
        try {
            list = this.agentLifecycleListeners.get(agent.getID());
        }
        finally {
            lock.readLock().unlock();
        }
        if (list != null) {
            List<Agent> singleton = Collections.singletonList(agent);
            SpawnServiceListener[] spawnServiceListenerArray = (SpawnServiceListener[])list.getListeners(SpawnServiceListener.class);
            int n = spawnServiceListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SpawnServiceListener l = spawnServiceListenerArray[n2];
                l.agentSpawned(spawningAgent, context, singleton, initializationParameters);
                ++n2;
            }
        }
    }

    @Override
    public boolean killAgent(UUID agentID, boolean forceKilling) {
        String warningMessage;
        Agent agent;
        boolean error = !this.isRunning();
        boolean isLast = false;
        Agent killAgent = null;
        ReadWriteLock lock = this.getAgentRepositoryLock();
        lock.readLock().lock();
        try {
            agent = this.agents.get(agentID);
        }
        finally {
            lock.readLock().unlock();
        }
        if (agent != null) {
            if (forceKilling || this.canKillAgent(agent)) {
                lock.writeLock().lock();
                try {
                    this.agents.remove(agentID);
                    isLast = this.agents.isEmpty();
                }
                finally {
                    lock.writeLock().unlock();
                }
                killAgent = agent;
                warningMessage = null;
            } else {
                warningMessage = Messages.StandardSpawnService_7;
            }
        } else {
            this.logger.getKernelLogger().finer(Messages.StandardSpawnService_8);
            return false;
        }
        if (warningMessage == null) {
            assert (killAgent != null);
            this.fireAgentKilled(killAgent);
            if (isLast) {
                this.fireKernelAgentDestroy();
            }
            if (error) {
                throw new SpawnServiceStopException(agentID);
            }
            return true;
        }
        if (killAgent != null) {
            try {
                Logging skill = SREutils.getInternalSkill(killAgent, Logging.class);
                if (skill != null) {
                    skill.warning((Object)warningMessage, new Object[0]);
                }
                this.logger.getKernelLogger().warning(warningMessage);
            }
            catch (Exception e) {
                throw new Error(Messages.StandardSpawnService_9, e);
            }
        } else {
            this.logger.getKernelLogger().warning(warningMessage);
        }
        return false;
    }

    @Override
    public SynchronizedSet<UUID> getAgents() {
        ReadWriteLock lock = this.getAgentRepositoryLock();
        lock.readLock().lock();
        try {
            SynchronizedSet<UUID> synchronizedSet = Collections3.synchronizedSet(this.agents.keySet(), lock);
            return synchronizedSet;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    Agent getAgent(UUID id) {
        assert (id != null);
        ReadWriteLock lock = this.getAgentRepositoryLock();
        lock.readLock().lock();
        try {
            Agent agent = this.agents.get(id);
            return agent;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Override
    public void addKernelAgentSpawnListener(KernelAgentSpawnListener listener) {
        this.globalListeners.add(KernelAgentSpawnListener.class, listener);
    }

    @Override
    public void removeKernelAgentSpawnListener(KernelAgentSpawnListener listener) {
        this.globalListeners.remove(KernelAgentSpawnListener.class, listener);
    }

    protected void fireKernelAgentSpawn() {
        KernelAgentSpawnListener[] kernelAgentSpawnListenerArray = (KernelAgentSpawnListener[])this.globalListeners.getListeners(KernelAgentSpawnListener.class);
        int n = kernelAgentSpawnListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            KernelAgentSpawnListener l = kernelAgentSpawnListenerArray[n2];
            l.kernelAgentSpawn();
            ++n2;
        }
    }

    protected void fireKernelAgentDestroy() {
        KernelAgentSpawnListener[] kernelAgentSpawnListenerArray = (KernelAgentSpawnListener[])this.globalListeners.getListeners(KernelAgentSpawnListener.class);
        int n = kernelAgentSpawnListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            KernelAgentSpawnListener l = kernelAgentSpawnListenerArray[n2];
            l.kernelAgentDestroy();
            ++n2;
        }
    }

    @Override
    public void addSpawnServiceListener(UUID id, SpawnServiceListener agentLifecycleListener) {
        ListenerCollection<SpawnServiceListener> listeners;
        ReadWriteLock lock = this.getAgentLifecycleListenerLock();
        lock.readLock().lock();
        try {
            listeners = this.agentLifecycleListeners.get(id);
        }
        finally {
            lock.readLock().unlock();
        }
        lock.writeLock().lock();
        try {
            if (listeners == null) {
                listeners = new ListenerCollection();
                this.agentLifecycleListeners.put(id, listeners);
            }
            listeners.add(SpawnServiceListener.class, agentLifecycleListener);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public void addSpawnServiceListener(SpawnServiceListener agentLifecycleListener) {
        this.globalListeners.add(SpawnServiceListener.class, agentLifecycleListener);
    }

    @Override
    public void removeSpawnServiceListener(UUID id, SpawnServiceListener agentLifecycleListener) {
        ListenerCollection<SpawnServiceListener> listeners;
        ReadWriteLock lock = this.getAgentLifecycleListenerLock();
        lock.readLock().lock();
        try {
            listeners = this.agentLifecycleListeners.get(id);
        }
        finally {
            lock.readLock().unlock();
        }
        lock.writeLock().lock();
        try {
            if (listeners != null) {
                listeners.remove(SpawnServiceListener.class, agentLifecycleListener);
                if (listeners.isEmpty()) {
                    this.agentLifecycleListeners.remove(id);
                }
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public void removeSpawnServiceListener(SpawnServiceListener agentLifecycleListener) {
        this.globalListeners.remove(SpawnServiceListener.class, agentLifecycleListener);
    }

    public boolean canKillAgent(Agent agent) {
        try {
            SynchronizedSet<UUID> participants;
            AgentContext ac = BuiltinCapacityUtil.getContextIn(agent);
            if (ac != null && (participants = ac.getDefaultSpace().getParticipants()) != null) {
                ReadWriteLock plock = participants.getLock();
                plock.readLock().lock();
                try {
                    if (participants.size() > 1 || participants.size() == 1 && !participants.contains(agent.getID())) {
                        plock.readLock().unlock();
                    }
                }
                catch (Throwable throwable) {
                    plock.readLock().unlock();
                    throw throwable;
                }
                plock.readLock().unlock();
            }
            return true;
        }
        finally {
            return false;
        }
    }

    protected void fireAgentKilled(Agent agent) {
        SpawnServiceListener l;
        ListenerCollection<SpawnServiceListener> list;
        ReadWriteLock llock = this.getAgentLifecycleListenerLock();
        llock.readLock().lock();
        try {
            list = this.agentLifecycleListeners.get(agent.getID());
        }
        finally {
            llock.readLock().unlock();
        }
        SpawnServiceListener[] ilisteners = list != null ? (SpawnServiceListener[])list.getListeners(SpawnServiceListener.class) : null;
        SpawnServiceListener[] ilisteners2 = (SpawnServiceListener[])this.globalListeners.getListeners(SpawnServiceListener.class);
        ArrayList<Pair<AgentContext, Address>> contextRegistrations = new ArrayList<Pair<AgentContext, Address>>();
        try {
            SynchronizedIterable<AgentContext> allContexts = BuiltinCapacityUtil.getContextsOf(agent);
            ReadWriteLock clock = allContexts.getLock();
            clock.readLock().lock();
            try {
                for (AgentContext context : allContexts) {
                    EventSpace defSpace = context.getDefaultSpace();
                    Address address2 = defSpace.getAddress(agent.getID());
                    contextRegistrations.add(Pair.of(context, address2));
                }
            }
            finally {
                clock.readLock().unlock();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (ilisteners != null) {
            SpawnServiceListener[] spawnServiceListenerArray = ilisteners;
            int context = ilisteners.length;
            int clock = 0;
            while (clock < context) {
                l = spawnServiceListenerArray[clock];
                l.agentDestroy(agent);
                ++clock;
            }
        }
        SpawnServiceListener[] spawnServiceListenerArray = ilisteners2;
        int context = ilisteners2.length;
        int clock = 0;
        while (clock < context) {
            l = spawnServiceListenerArray[clock];
            l.agentDestroy(agent);
            ++clock;
        }
        try {
            UUID killedAgentId = agent.getID();
            Scope<Address> scope = address -> {
                UUID receiver = address.getUUID();
                return !receiver.equals(killedAgentId);
            };
            String killedAgentType = agent.getClass().getName();
            for (Pair pair : contextRegistrations) {
                EventSpace defSpace = ((AgentContext)pair.getKey()).getDefaultSpace();
                defSpace.emit(null, new AgentKilled((Address)pair.getValue(), killedAgentId, killedAgentType), scope);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doStart() {
        this.fireKernelAgentSpawn();
        this.notifyStarted();
    }

    @Override
    protected void doStop() {
        ReadWriteLock lock = this.getAgentLifecycleListenerLock();
        lock.writeLock().lock();
        try {
            this.agentLifecycleListeners.clear();
        }
        finally {
            lock.writeLock().unlock();
        }
        this.notifyStopped();
    }

    public static class CannotSpawnException
    extends RuntimeException {
        private static final long serialVersionUID = -380402400888610762L;

        public CannotSpawnException(Class<? extends Agent> agentClazz, Throwable cause) {
            super(MessageFormat.format(Messages.StandardSpawnService_3, agentClazz, cause == null ? null : cause.getLocalizedMessage()), cause);
        }
    }

    public static class InvalidSarlSpecificationException
    extends RuntimeException {
        private static final long serialVersionUID = -3194494637438344108L;

        public InvalidSarlSpecificationException(Class<? extends Agent> agentType) {
            super(MessageFormat.format(Messages.StandardSpawnService_2, agentType.getName()));
        }
    }

    private static class JustInTimeAgentInjectionModule
    extends AbstractModule
    implements Provider<Agent> {
        private final Class<? extends Agent> agentType;
        private final Constructor<? extends Agent> constructor1;
        private final Constructor<? extends Agent> constructor2;
        private final UUID parentID;
        private UUID agentID;

        JustInTimeAgentInjectionModule(Class<? extends Agent> agentType, UUID parentID, UUID agentID) {
            Constructor<? extends Agent> cons;
            assert (agentType != null);
            assert (parentID != null);
            this.agentType = agentType;
            this.parentID = parentID;
            this.agentID = agentID;
            Exception e1 = null;
            try {
                cons = this.agentType.getConstructor(UUID.class, UUID.class);
            }
            catch (IllegalArgumentException | NoSuchMethodException | SecurityException exception) {
                cons = null;
                e1 = exception;
            }
            this.constructor1 = cons;
            Exception e2 = null;
            try {
                cons = this.agentType.getConstructor(BuiltinCapacitiesProvider.class, UUID.class, UUID.class);
            }
            catch (IllegalArgumentException | NoSuchMethodException | SecurityException exception) {
                cons = null;
                e2 = exception;
            }
            this.constructor2 = cons;
            if (this.constructor1 == null && this.constructor2 == null) {
                throw new CannotSpawnException(this.agentType, (Throwable)(e1 == null ? e2 : e1));
            }
        }

        @Override
        public void configure() {
            this.bind(Agent.class).toProvider(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Agent get() {
            UUID agId;
            JustInTimeAgentInjectionModule justInTimeAgentInjectionModule = this;
            synchronized (justInTimeAgentInjectionModule) {
                agId = this.agentID;
                this.agentID = null;
            }
            if (agId == null) {
                agId = UUID.randomUUID();
            }
            assert (this.constructor1 != null || this.constructor2 != null);
            try {
                if (this.constructor1 != null) {
                    this.constructor1.setAccessible(true);
                    return this.constructor1.newInstance(this.parentID, agId);
                }
                this.constructor2.setAccessible(true);
                return this.constructor2.newInstance(null, this.parentID, agId);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException exception) {
                throw new CannotSpawnException(this.agentType, (Throwable)exception);
            }
        }
    }

    public static class SpawnDisabledException
    extends RuntimeException {
        private static final long serialVersionUID = -380402400888610762L;

        public SpawnDisabledException(UUID parentID, Class<? extends Agent> agentClazz) {
            super(MessageFormat.format(Messages.StandardSpawnService_0, parentID, agentClazz));
        }
    }

    public static class SpawnServiceStopException
    extends RuntimeException {
        private static final long serialVersionUID = 8104012713598435249L;

        public SpawnServiceStopException(UUID agentID) {
            super(MessageFormat.format(Messages.StandardSpawnService_1, agentID));
        }
    }
}

