/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.network;

import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.janusproject.services.network.AbstractNetworkingService;
import io.janusproject.services.network.NetworkService;
import io.janusproject.services.network.NetworkServiceListener;
import io.janusproject.services.network.NetworkUtil;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Scope;
import io.sarl.lang.core.SpaceID;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Singleton
public class NoNetworkService
extends AbstractNetworkingService {
    private final List<NetworkServiceListener> listeners = new ArrayList<NetworkServiceListener>();
    private URI localHost;

    @Inject
    public NoNetworkService() {
    }

    protected final Object getServiceMutex() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI getURI() {
        Object object = this.getServiceMutex();
        synchronized (object) {
            return this.localHost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNetworkServiceListener(NetworkServiceListener listener) {
        Object object = this.getServiceMutex();
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNetworkServiceListener(NetworkServiceListener listener) {
        Object object = this.getServiceMutex();
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void publish(Scope<?> scope, Event data) throws Exception {
    }

    @Override
    public void connectToRemoteSpaces(URI peerUri, SpaceID space, NetworkService.NetworkEventReceivingListener listener) throws Exception {
    }

    @Override
    public void disconnectFromRemoteSpace(URI peer, SpaceID space) throws Exception {
    }

    @Override
    public void disconnectPeer(URI peer) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        URI newLocalHost;
        InetAddress adr = NetworkUtil.getLoopbackAddress();
        if (adr == null) {
            try {
                newLocalHost = NetworkUtil.toURI("tcp://127.0.0.1:0");
            }
            catch (URISyntaxException e) {
                throw new Error(e);
            }
        } else {
            newLocalHost = NetworkUtil.toURI(adr, 0);
        }
        Object object = this.getServiceMutex();
        synchronized (object) {
            this.localHost = newLocalHost;
        }
        this.notifyStarted();
    }

    @Override
    protected void doStop() {
        this.notifyStopped();
    }

    @Override
    public Collection<Class<? extends Service>> getServiceDependencies() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Class<? extends Service>> getServiceWeakDependencies() {
        return Collections.emptyList();
    }
}

