/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.logging;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.Service;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.logging.LogService;
import io.janusproject.util.LoggerCreator;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class StandardLogService
extends AbstractDependentService
implements LogService {
    private Logger platformLogger;
    private Logger kernelLogger;

    @Override
    public final Class<? extends Service> getServiceType() {
        return LogService.class;
    }

    @Override
    public Logger getPlatformLogger() {
        if (this.platformLogger == null) {
            this.platformLogger = LoggerCreator.createPlatformLogger();
        }
        return this.platformLogger;
    }

    @Override
    public Logger getKernelLogger() {
        if (this.kernelLogger == null) {
            this.kernelLogger = LoggerCreator.createModuleLogger("Janus SRE", this.getPlatformLogger());
        }
        return this.kernelLogger;
    }

    @Override
    public LogRecord prepareLogRecord(LogRecord record, String loggerName, Throwable exception) {
        String name = record.getLoggerName();
        if (Strings.isNullOrEmpty(name)) {
            if (!Strings.isNullOrEmpty(loggerName)) {
                record.setLoggerName(loggerName);
            } else {
                record.setLoggerName("Janus SRE");
            }
        }
        if (exception != null) {
            record.setThrown(exception);
            StackTraceElement[] trace = exception.getStackTrace();
            if (trace != null && trace.length > 0) {
                StackTraceElement elt = trace[0];
                assert (elt != null);
                record.setSourceClassName(elt.getClassName());
                record.setSourceMethodName(elt.getMethodName());
            }
        }
        return record;
    }

    @Override
    protected void doStart() {
        this.notifyStarted();
    }

    @Override
    protected void doStop() {
        this.notifyStopped();
    }
}

