/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.executors;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.janusproject.kernel.services.jdk.executors.Messages;
import io.janusproject.services.executor.EarlyExitException;
import io.janusproject.services.logging.LogService;
import java.text.MessageFormat;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

@Singleton
public class JdkUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private LogService logger;

    @Deprecated
    public JdkUncaughtExceptionHandler(LogService logger) {
        assert (logger != null);
        this.logger = logger;
    }

    public JdkUncaughtExceptionHandler() {
    }

    @Inject
    public void setLogService(LogService logger) {
        assert (logger != null);
        this.logger = logger;
    }

    private void log(Throwable exception, String taskId, String taskName, String loggerName) {
        LogRecord record;
        assert (exception != null);
        Throwable cause = exception;
        while (cause.getCause() != null && cause.getCause() != cause) {
            cause = cause.getCause();
        }
        if (cause instanceof EarlyExitException || exception instanceof EarlyExitException) {
            return;
        }
        if (cause instanceof CancellationException || exception instanceof CancellationException) {
            if (!this.logger.getKernelLogger().isLoggable(Level.FINEST)) {
                return;
            }
            record = new LogRecord(Level.FINEST, MessageFormat.format(Messages.JdkUncaughtExceptionHandler_0, taskId, taskName));
        } else if (cause instanceof InterruptedException || exception instanceof InterruptedException) {
            if (!this.logger.getKernelLogger().isLoggable(Level.FINEST)) {
                return;
            }
            record = new LogRecord(Level.FINEST, MessageFormat.format(Messages.JdkUncaughtExceptionHandler_1, taskId, taskName));
        } else {
            if (!this.logger.getKernelLogger().isLoggable(Level.SEVERE)) {
                return;
            }
            record = new LogRecord(Level.SEVERE, MessageFormat.format(Messages.JdkUncaughtExceptionHandler_2, cause.getLocalizedMessage(), taskId, taskName));
        }
        Logger backLogger = this.logger.getKernelLogger();
        String name = !Strings.isNullOrEmpty(loggerName) ? loggerName : backLogger.getName();
        LogRecord preparedLogRecord = this.logger.prepareLogRecord(record, name, cause);
        backLogger.log(preparedLogRecord);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        this.log(exception, Long.toString(thread.getId()), thread.getName(), null);
    }
}

