/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.executors;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.janusproject.kernel.services.jdk.executors.Messages;
import io.janusproject.services.logging.LogService;
import java.text.MessageFormat;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.LogRecord;

@Singleton
public class JdkRejectedExecutionHandler
implements RejectedExecutionHandler {
    private final LogService logger;

    @Inject
    public JdkRejectedExecutionHandler(LogService logger) {
        assert (logger != null);
        this.logger = logger;
    }

    @Override
    public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
        if (!JdkRejectedExecutionHandler.runRejectedTask(task, executor)) {
            LogRecord record = new LogRecord(Level.FINE, MessageFormat.format(Messages.JdkRejectedExecutionHandler_0, task.toString()));
            this.logger.getKernelLogger().log(record);
        }
    }

    protected static boolean runRejectedTask(Runnable runnable, ThreadPoolExecutor executor) {
        if (!executor.isShutdown()) {
            runnable.run();
            return true;
        }
        return false;
    }
}

