/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.executors;

import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.janusproject.JanusConfig;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.executor.JanusCallable;
import io.janusproject.services.executor.JanusRunnable;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@Singleton
public class JdkExecutorService
extends AbstractDependentService
implements ExecutorService {
    private ScheduledExecutorService schedules;
    private java.util.concurrent.ExecutorService exec;
    private ScheduledFuture<?> purgeTask;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    @Inject
    void setScheduledExecutorService(ScheduledExecutorService service) {
        this.schedules = service;
    }

    @Inject
    void setExecutorService(java.util.concurrent.ExecutorService service) {
        this.exec = service;
    }

    @Inject
    void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.uncaughtExceptionHandler = handler;
    }

    @Override
    public final Class<? extends Service> getServiceType() {
        return ExecutorService.class;
    }

    @Override
    protected void doStart() {
        assert (this.schedules != null);
        assert (this.exec != null);
        if (this.uncaughtExceptionHandler != null) {
            Thread.setDefaultUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        }
        if (this.schedules instanceof ThreadPoolExecutor || this.exec instanceof ThreadPoolExecutor) {
            int delay = JanusConfig.getSystemPropertyAsInteger("janus.executors.purgeDelay", 30);
            this.purgeTask = this.schedules.scheduleWithFixedDelay(new Purger(), delay, delay, TimeUnit.SECONDS);
        }
        this.notifyStarted();
    }

    @Override
    protected void doStop() {
        if (this.purgeTask != null) {
            this.purgeTask.cancel(true);
            this.purgeTask = null;
        }
        this.exec.shutdown();
        this.schedules.shutdown();
        try {
            try {
                int timeout = JanusConfig.getSystemPropertyAsInteger("janus.executors.timeout", 30);
                this.schedules.awaitTermination(timeout, TimeUnit.SECONDS);
                this.exec.awaitTermination(timeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                this.schedules.shutdownNow();
                this.exec.shutdownNow();
                this.notifyStopped();
            }
        }
        finally {
            this.schedules.shutdownNow();
            this.exec.shutdownNow();
            this.notifyStopped();
        }
    }

    protected Runnable createTask(Runnable runnable) {
        if (runnable instanceof JanusRunnable) {
            return runnable;
        }
        return new JanusRunnable(runnable);
    }

    protected <T> Callable<T> createTask(Callable<T> callable) {
        if (callable instanceof JanusCallable) {
            return callable;
        }
        return new JanusCallable<T>(callable);
    }

    @Override
    public void execute(Runnable task) {
        this.exec.execute(this.createTask(task));
    }

    @Override
    public int executeMultipleTimesInParallelAndWaitForTermination(Runnable task, int nbExecutions, int runGroupSize) throws InterruptedException {
        assert (runGroupSize >= 1);
        Runnable janusTask = this.createTask(task);
        if (nbExecutions > 1) {
            AtomicInteger errors = new AtomicInteger();
            CountDownLatch doneSignal = new CountDownLatch(nbExecutions);
            if (runGroupSize > 1) {
                int numberOfGroups = nbExecutions / runGroupSize;
                int rest = nbExecutions - numberOfGroups * runGroupSize;
                int i = 0;
                while (i < numberOfGroups) {
                    this.exec.execute(() -> {
                        int j = 0;
                        while (j < runGroupSize) {
                            block6: {
                                try {
                                    try {
                                        janusTask.run();
                                    }
                                    catch (Throwable e) {
                                        errors.incrementAndGet();
                                        doneSignal.countDown();
                                        break block6;
                                    }
                                }
                                catch (Throwable throwable) {
                                    doneSignal.countDown();
                                    throw throwable;
                                }
                                doneSignal.countDown();
                            }
                            ++j;
                        }
                    });
                    ++i;
                }
                if (rest > 1) {
                    this.exec.execute(() -> {
                        int j = 0;
                        while (j < rest) {
                            block6: {
                                try {
                                    try {
                                        janusTask.run();
                                    }
                                    catch (Throwable e) {
                                        errors.incrementAndGet();
                                        doneSignal.countDown();
                                        break block6;
                                    }
                                }
                                catch (Throwable throwable) {
                                    doneSignal.countDown();
                                    throw throwable;
                                }
                                doneSignal.countDown();
                            }
                            ++j;
                        }
                    });
                }
            } else {
                int i = 0;
                while (i < nbExecutions) {
                    this.exec.execute(() -> {
                        try {
                            try {
                                janusTask.run();
                            }
                            catch (Throwable e) {
                                errors.incrementAndGet();
                                doneSignal.countDown();
                            }
                        }
                        finally {
                            doneSignal.countDown();
                        }
                    });
                    ++i;
                }
            }
            doneSignal.await();
            return nbExecutions - errors.get();
        }
        if (nbExecutions == 1) {
            janusTask.run();
            return 1;
        }
        return 0;
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.exec.submit(this.createTask(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.exec.submit(this.createTask(task), result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.exec.submit(this.createTask(task));
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.schedules.schedule(this.createTask(command), delay, unit);
    }

    @Override
    public <T> ScheduledFuture<T> schedule(Callable<T> command, long delay, TimeUnit unit) {
        return this.schedules.schedule(this.createTask(command), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.schedules.scheduleAtFixedRate(this.createTask(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.schedules.scheduleWithFixedDelay(this.createTask(command), initialDelay, delay, unit);
    }

    @Override
    public java.util.concurrent.ExecutorService getExecutorService() {
        return this.exec;
    }

    @Override
    public void purge() {
        if (this.exec instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.exec).purge();
        }
        if (this.schedules instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)((Object)this.schedules)).purge();
        }
    }

    private class Purger
    implements Runnable {
        private String oldThreadName;

        Purger() {
        }

        private boolean setName() {
            if (this.oldThreadName != null) {
                return false;
            }
            Thread t = Thread.currentThread();
            this.oldThreadName = t.getName();
            t.setName(this.toString());
            return true;
        }

        private boolean restoreName() {
            if (this.oldThreadName == null) {
                return false;
            }
            Thread t = Thread.currentThread();
            t.setName(this.oldThreadName);
            this.oldThreadName = null;
            return true;
        }

        @Override
        public void run() {
            assert (this.setName());
            try {
                JdkExecutorService.this.purge();
            }
            finally {
                assert (this.restoreName());
            }
        }

        public String toString() {
            return "Janus Thread Purger";
        }
    }
}

