/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.contextspace;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import io.janusproject.services.contextspace.SpaceRepositoryListener;
import io.janusproject.services.distributeddata.DMap;
import io.janusproject.services.distributeddata.DMapListener;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.janusproject.util.Comparators;
import io.janusproject.util.TwoStepConstruction;
import io.sarl.core.OpenEventSpace;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.core.SpaceSpecification;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.util.DefaultSpace;
import io.sarl.util.concurrent.Collections3;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;

@TwoStepConstruction
public class SpaceRepository {
    private static final Object[] NO_PARAMETERS = new Object[0];
    private final String distributedSpaceSetName;
    private final Injector injector;
    private SpaceDMapListener internalListener;
    private final SpaceRepositoryListener externalListener;
    private final DMap<SpaceID, Object[]> spaceIDs;
    private final ReadWriteLock spaceIDsLock;
    private final Map<SpaceID, Space> spaces;
    private final ReadWriteLock spacesLock;
    private final Multimap<Class<? extends SpaceSpecification<?>>, SpaceID> spacesBySpec;
    private WeakReference<OpenEventSpace> defaultSpace;

    SpaceRepository(String distributedSpaceSetName, DistributedDataStructureService distributedDataStructureService, Injector injector, SpaceRepositoryListener listener) {
        this.distributedSpaceSetName = distributedSpaceSetName;
        this.injector = injector;
        this.externalListener = listener;
        Provider<ReadWriteLock> provider = this.injector.getProvider(ReadWriteLock.class);
        this.spaceIDsLock = provider.get();
        this.spacesLock = provider.get();
        this.spaces = new TreeMap<SpaceID, Space>();
        this.spacesBySpec = TreeMultimap.create(Comparators.CLASS_COMPARATOR, Comparators.OBJECT_COMPARATOR);
        this.spaceIDs = distributedDataStructureService.getMap(this.distributedSpaceSetName, null);
    }

    void postConstruction() {
        if (this.spaceIDs != null) {
            for (Map.Entry e : this.spaceIDs.entrySet()) {
                assert (this.spaceIDs.containsKey(e.getKey()));
                this.ensureLocalSpaceDefinition((SpaceID)e.getKey(), (Object[])e.getValue());
            }
            this.internalListener = new SpaceDMapListener();
            this.spaceIDs.addDMapListener(this.internalListener);
        }
    }

    protected ReadWriteLock getSpaceRepositoryLock() {
        return this.spacesLock;
    }

    protected ReadWriteLock getSpaceIDsLock() {
        return this.spaceIDsLock;
    }

    public void destroy() {
        ArrayList ids;
        ReadWriteLock lock = this.getSpaceIDsLock();
        lock.writeLock().lock();
        try {
            if (this.internalListener != null) {
                this.spaceIDs.removeDMapListener(this.internalListener);
            }
            ids = new ArrayList(this.spaceIDs.keySet());
            this.spaceIDs.clear();
        }
        finally {
            lock.writeLock().unlock();
        }
        for (SpaceID spaceId : ids) {
            this.removeLocalSpaceDefinition(spaceId, true);
        }
        this.defaultSpace = null;
    }

    private <S extends Space> S createSpaceInstance(Class<? extends SpaceSpecification<S>> spec, SpaceID spaceID, boolean isLocalCreation, Object[] creationParams) {
        Injector defaultSpaceInjector;
        OpenEventSpace defaultSpace;
        assert (spaceID.getSpaceSpecification() == null || spaceID.getSpaceSpecification().equals(spec)) : "The specification type is invalid";
        OpenEventSpace openEventSpace = defaultSpace = this.defaultSpace == null ? null : (OpenEventSpace)this.defaultSpace.get();
        if (defaultSpace == null) {
            defaultSpaceInjector = this.injector;
        } else {
            JustInTimeDefaultSpaceInjectionModule defaultSpaceInjectionModule = new JustInTimeDefaultSpaceInjectionModule(defaultSpace);
            defaultSpaceInjector = this.injector.createChildInjector(defaultSpaceInjectionModule);
        }
        SpaceSpecification<S> spaceSpecificationInstance = defaultSpaceInjector.getInstance(spec);
        S space = creationParams != null && creationParams.length > 0 ? spaceSpecificationInstance.create(spaceID, creationParams) : spaceSpecificationInstance.create(spaceID, new Object[0]);
        assert (space != null);
        SpaceID id = space.getSpaceID();
        assert (id != null);
        this.spaces.put(id, (Space)space);
        this.spacesBySpec.put(id.getSpaceSpecification(), id);
        if (isLocalCreation) {
            Object[] sharedParams = NO_PARAMETERS;
            if (creationParams != null && creationParams.length > 0) {
                ArrayList<Object> serializableParameters = new ArrayList<Object>(creationParams.length);
                Object[] objectArray = creationParams;
                int n = creationParams.length;
                int n2 = 0;
                while (n2 < n) {
                    Object creationParameter = objectArray[n2];
                    if (creationParameter instanceof Serializable) {
                        serializableParameters.add(creationParameter);
                    }
                    ++n2;
                }
                if (!serializableParameters.isEmpty()) {
                    sharedParams = serializableParameters.toArray();
                }
            }
            ReadWriteLock lock = this.getSpaceIDsLock();
            lock.writeLock().lock();
            try {
                this.spaceIDs.putIfAbsent(id, sharedParams);
            }
            finally {
                lock.writeLock().unlock();
            }
        }
        this.fireSpaceAdded((Space)space, isLocalCreation);
        return space;
    }

    protected void ensureLocalSpaceDefinition(SpaceID id, Object[] initializationParameters) {
        boolean create;
        ReadWriteLock lock = this.getSpaceRepositoryLock();
        lock.readLock().lock();
        try {
            create = !this.spaces.containsKey(id);
        }
        finally {
            lock.readLock().unlock();
        }
        if (create) {
            lock.writeLock().lock();
            try {
                this.createSpaceInstance(id.getSpaceSpecification(), id, false, initializationParameters);
            }
            finally {
                lock.writeLock().unlock();
            }
        }
    }

    protected void removeLocalSpaceDefinition(SpaceID id, boolean isLocalDestruction) {
        Space space;
        ReadWriteLock lock = this.getSpaceRepositoryLock();
        lock.writeLock().lock();
        try {
            space = this.spaces.remove(id);
            if (space != null) {
                this.spacesBySpec.remove(id.getSpaceSpecification(), id);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
        if (space != null) {
            this.fireSpaceRemoved(space, isLocalDestruction);
        }
    }

    protected void removeLocalSpaceDefinitions(boolean isLocalDestruction) {
        ArrayList<Space> removedSpaces = null;
        ReadWriteLock lock = this.getSpaceRepositoryLock();
        lock.readLock().lock();
        try {
            if (!this.spaces.isEmpty()) {
                removedSpaces = new ArrayList<Space>(this.spaces.size());
            }
        }
        finally {
            lock.readLock().unlock();
        }
        if (removedSpaces != null) {
            lock.writeLock().lock();
            try {
                Iterator<Map.Entry<SpaceID, Space>> iterator = this.spaces.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<SpaceID, Space> entry = iterator.next();
                    SpaceID id = entry.getKey();
                    Space space = entry.getValue();
                    iterator.remove();
                    this.spacesBySpec.remove(id.getSpaceSpecification(), id);
                    removedSpaces.add(space);
                }
            }
            finally {
                lock.writeLock().unlock();
            }
            for (Space s2 : removedSpaces) {
                this.fireSpaceRemoved(s2, isLocalDestruction);
            }
        }
    }

    public <S extends Space> S createSpace(SpaceID spaceID, Class<? extends SpaceSpecification<S>> spec, Object ... creationParams) {
        boolean create;
        ReadWriteLock lock = this.getSpaceRepositoryLock();
        lock.readLock().lock();
        try {
            create = !this.spaces.containsKey(spaceID);
        }
        finally {
            lock.readLock().unlock();
        }
        if (create) {
            lock.writeLock().lock();
            try {
                S s2 = this.createSpaceInstance(spec, spaceID, true, creationParams);
                return s2;
            }
            finally {
                lock.writeLock().unlock();
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <S extends Space> S getOrCreateSpaceWithSpec(SpaceID spaceID, Class<? extends SpaceSpecification<S>> spec, Object ... creationParams) {
        block10: {
            firstSpace = null;
            lock = this.getSpaceRepositoryLock();
            lock.readLock().lock();
            try {
                block12: {
                    ispaces = this.spacesBySpec.get(spec);
                    if (ispaces == null || ispaces.isEmpty()) break block10;
                    v0 = defaultSpace = this.defaultSpace == null ? null : (OpenEventSpace)this.defaultSpace.get();
                    if (defaultSpace != null) break block12;
                    idIterator = ispaces.iterator();
                    if (true) ** GOTO lbl18
                }
                defaultSpaceId = defaultSpace.getSpaceID();
                idIterator = ispaces.iterator();
                if (true) ** GOTO lbl23
                do {
                    currentId = idIterator.next();
                    firstSpace = this.spaces.get(currentId);
lbl18:
                    // 2 sources

                } while (firstSpace == null && idIterator.hasNext());
                break block10;
                do {
                    if (defaultSpaceId.equals(currentId = idIterator.next())) continue;
                    firstSpace = this.spaces.get(currentId);
lbl23:
                    // 3 sources

                } while (firstSpace == null && idIterator.hasNext());
            }
            finally {
                lock.readLock().unlock();
            }
        }
        if (firstSpace == null) {
            lock.writeLock().lock();
            try {
                firstSpace = (Space)this.createSpaceInstance(spec, spaceID, true, creationParams);
            }
            finally {
                lock.writeLock().unlock();
            }
        }
        if (!SpaceRepository.$assertionsDisabled && firstSpace == null) {
            throw new AssertionError();
        }
        return (S)firstSpace;
    }

    public <S extends Space> S getOrCreateSpaceWithID(SpaceID spaceID, Class<? extends SpaceSpecification<S>> spec, Object ... creationParams) {
        Space space;
        ReadWriteLock lock = this.getSpaceRepositoryLock();
        lock.readLock().lock();
        try {
            space = this.spaces.get(spaceID);
        }
        finally {
            lock.readLock().unlock();
        }
        if (space == null) {
            lock.writeLock().lock();
            try {
                space = this.createSpaceInstance(spec, spaceID, true, creationParams);
            }
            finally {
                lock.writeLock().unlock();
            }
        }
        assert (space != null);
        return (S)space;
    }

    public SynchronizedCollection<? extends Space> getSpaces() {
        ReadWriteLock lock = this.getSpaceRepositoryLock();
        lock.readLock().lock();
        try {
            SynchronizedCollection<Space> synchronizedCollection = Collections3.unmodifiableSynchronizedCollection(this.spaces.values(), lock);
            return synchronizedCollection;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public <S extends Space> SynchronizedCollection<S> getSpaces(final Class<? extends SpaceSpecification<S>> spec) {
        ReadWriteLock lock = this.getSpaceRepositoryLock();
        lock.readLock().lock();
        try {
            Collection<Space> backed = Collections2.filter(this.spaces.values(), new Predicate<Space>(){

                @Override
                public boolean apply(Space input) {
                    return input.getSpaceID().getSpaceSpecification().equals(spec);
                }
            });
            SynchronizedCollection<Space> synchronizedCollection = Collections3.unmodifiableSynchronizedCollection(backed, lock);
            return synchronizedCollection;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public Space getSpace(SpaceID spaceID) {
        ReadWriteLock lock = this.getSpaceRepositoryLock();
        lock.readLock().lock();
        try {
            Space space = this.spaces.get(spaceID);
            return space;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    protected void fireSpaceAdded(Space space, boolean isLocalCreation) {
        if (this.externalListener != null) {
            this.externalListener.spaceCreated(space, isLocalCreation);
        }
    }

    protected void fireSpaceRemoved(Space space, boolean isLocalDestruction) {
        if (this.externalListener != null) {
            this.externalListener.spaceDestroyed(space, isLocalDestruction);
        }
    }

    final void setDefaultSpace(OpenEventSpace defaultSpace) {
        this.defaultSpace = defaultSpace == null ? null : new WeakReference<OpenEventSpace>(defaultSpace);
    }

    private static class JustInTimeDefaultSpaceInjectionModule
    extends AbstractModule {
        private static final String NAME = "defaultSpace";
        private final OpenEventSpace defaultSpace;

        JustInTimeDefaultSpaceInjectionModule(OpenEventSpace defaultSpace) {
            assert (defaultSpace != null);
            this.defaultSpace = defaultSpace;
        }

        @Override
        public void configure() {
            this.bind(OpenEventSpace.class).annotatedWith(Names.named(NAME)).toInstance(this.defaultSpace);
            this.bind(OpenEventSpace.class).annotatedWith(DefaultSpace.class).toInstance(this.defaultSpace);
        }
    }

    private class SpaceDMapListener
    implements DMapListener<SpaceID, Object[]> {
        SpaceDMapListener() {
        }

        @Override
        public void entryAdded(SpaceID key, Object[] value) {
            assert (SpaceRepository.this.spaceIDs.containsKey(key));
            SpaceRepository.this.ensureLocalSpaceDefinition(key, value);
        }

        @Override
        public void entryRemoved(SpaceID key, Object[] value) {
            assert (!SpaceRepository.this.spaceIDs.containsKey(key));
            SpaceRepository.this.removeLocalSpaceDefinition(key, false);
        }

        @Override
        public void entryUpdated(SpaceID key, Object[] value) {
        }

        @Override
        public void mapCleared(boolean localClearing) {
            SpaceRepository.this.removeLocalSpaceDefinitions(false);
        }
    }
}

