/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.contextspace;

import com.google.inject.Injector;
import io.janusproject.kernel.services.jdk.contextspace.Messages;
import io.janusproject.kernel.services.jdk.contextspace.SpaceRepository;
import io.janusproject.kernel.services.jdk.contextspace.SpaceRepositoryFactory;
import io.janusproject.services.contextspace.SpaceRepositoryListener;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.janusproject.services.logging.LogService;
import io.janusproject.util.TwoStepConstruction;
import io.sarl.core.OpenEventSpace;
import io.sarl.core.OpenEventSpaceSpecification;
import io.sarl.core.SpaceCreated;
import io.sarl.core.SpaceDestroyed;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.core.SpaceSpecification;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.lang.util.SynchronizedIterable;
import io.sarl.util.concurrent.Collections3;
import java.text.MessageFormat;
import java.util.UUID;

@TwoStepConstruction
public class Context
implements AgentContext {
    private final UUID id;
    private final SpaceRepository spaceRepository;
    private final UUID defaultSpaceID;
    private OpenEventSpace defaultSpace;

    public Context(UUID id, UUID defaultSpaceID, SpaceRepositoryFactory factory, SpaceRepositoryListener startUpListener) {
        assert (factory != null);
        this.id = id;
        this.defaultSpaceID = defaultSpaceID;
        this.spaceRepository = factory.newInstance(this, String.valueOf(id.toString()) + "-spaces", startUpListener);
    }

    public String toString() {
        return this.id.toString();
    }

    public EventSpace postConstruction() {
        this.spaceRepository.postConstruction();
        this.defaultSpace = (OpenEventSpace)this.createSpace(OpenEventSpaceSpecification.class, this.defaultSpaceID, new Object[0]);
        if (this.defaultSpace == null) {
            this.defaultSpace = (OpenEventSpace)this.spaceRepository.getSpace(new SpaceID(this.id, this.defaultSpaceID, OpenEventSpaceSpecification.class));
        }
        this.spaceRepository.setDefaultSpace(this.defaultSpace);
        return this.defaultSpace;
    }

    public void destroy() {
        this.spaceRepository.destroy();
    }

    @Override
    public UUID getID() {
        return this.id;
    }

    @Override
    public OpenEventSpace getDefaultSpace() {
        return this.defaultSpace;
    }

    @Override
    public <S extends Space> SynchronizedIterable<S> getSpaces(Class<? extends SpaceSpecification<S>> spec) {
        SynchronizedCollection col = this.spaceRepository.getSpaces(spec);
        return Collections3.unmodifiableSynchronizedIterable(col, col.getLock());
    }

    @Override
    public SynchronizedIterable<? extends Space> getSpaces() {
        SynchronizedCollection<? extends Space> col = this.spaceRepository.getSpaces();
        return Collections3.unmodifiableSynchronizedIterable(col, col.getLock());
    }

    @Override
    public <S extends Space> S createSpace(Class<? extends SpaceSpecification<S>> spec, UUID spaceUUID, Object ... creationParams) {
        return this.spaceRepository.createSpace(new SpaceID(this.id, spaceUUID, spec), spec, creationParams);
    }

    @Override
    public <S extends Space> S getOrCreateSpaceWithSpec(Class<? extends SpaceSpecification<S>> spec, UUID spaceUUID, Object ... creationParams) {
        return this.spaceRepository.getOrCreateSpaceWithSpec(new SpaceID(this.id, spaceUUID, spec), spec, creationParams);
    }

    @Override
    public <S extends Space> S getOrCreateSpaceWithID(Class<? extends SpaceSpecification<S>> spec, UUID spaceUUID, Object ... creationParams) {
        return this.spaceRepository.getOrCreateSpaceWithID(new SpaceID(this.id, spaceUUID, spec), spec, creationParams);
    }

    @Override
    public <S extends Space> S getSpace(UUID spaceUUID) {
        return (S)this.spaceRepository.getSpace(new SpaceID(this.id, spaceUUID, null));
    }

    public static class DefaultSpaceRepositoryFactory
    implements SpaceRepositoryFactory {
        private final DistributedDataStructureService dataStructureService;
        private final Injector injector;
        private final LogService logger;

        public DefaultSpaceRepositoryFactory(Injector injector, DistributedDataStructureService distributedDataStructure, LogService logger) {
            this.dataStructureService = distributedDataStructure;
            this.injector = injector;
            this.logger = logger;
        }

        @Override
        public final SpaceRepository newInstance(Context context, String distributedSpaceSetName, SpaceRepositoryListener listener) {
            return this.newInstanceWithPrivateSpaceListener(context, distributedSpaceSetName, new SpaceListener(context, this.logger, listener));
        }

        protected SpaceRepository newInstanceWithPrivateSpaceListener(Context context, String distributedSpaceSetName, SpaceRepositoryListener listener) {
            return new SpaceRepository(distributedSpaceSetName, this.dataStructureService, this.injector, listener);
        }
    }

    private static class SpaceListener
    implements SpaceRepositoryListener {
        private final Context context;
        private final SpaceRepositoryListener relay;
        private final LogService logger;

        SpaceListener(Context context, LogService logger, SpaceRepositoryListener relay) {
            assert (context != null);
            assert (logger != null);
            assert (relay != null);
            this.context = context;
            this.logger = logger;
            this.relay = relay;
        }

        @Override
        public void spaceCreated(Space space, boolean isLocalCreation) {
            OpenEventSpace defSpace;
            this.logger.getKernelLogger().info(MessageFormat.format(Messages.Context_0, space.getSpaceID()));
            this.relay.spaceCreated(space, isLocalCreation);
            if (isLocalCreation && (defSpace = this.context.getDefaultSpace()) != null) {
                defSpace.emit(null, new SpaceCreated(new Address(defSpace.getSpaceID(), this.context.getID()), space.getSpaceID()));
            }
        }

        @Override
        public void spaceDestroyed(Space space, boolean isLocalDestruction) {
            OpenEventSpace defSpace;
            this.logger.getKernelLogger().info(MessageFormat.format(Messages.Context_1, space.getSpaceID()));
            if (isLocalDestruction && (defSpace = this.context.getDefaultSpace()) != null) {
                defSpace.emit(null, new SpaceDestroyed(new Address(defSpace.getSpaceID(), this.context.getID()), space.getSpaceID()));
            }
            this.relay.spaceDestroyed(space, isLocalDestruction);
        }
    }
}

