/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.hazelcast;

import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryEvictedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import io.janusproject.kernel.services.hazelcast.Messages;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.AsyncStateService;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.kerneldiscovery.KernelDiscoveryService;
import io.janusproject.services.kerneldiscovery.KernelDiscoveryServiceListener;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.network.NetworkService;
import io.janusproject.services.network.NetworkUtil;
import io.janusproject.util.ListenerCollection;
import io.janusproject.util.TwoStepConstruction;
import java.net.InetSocketAddress;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;

@Singleton
@TwoStepConstruction
public class HazelcastKernelDiscoveryService
extends AbstractDependentService
implements KernelDiscoveryService,
AsyncStateService {
    private final UUID janusID;
    private URI currentPubURI;
    private URI currentHzURI;
    private IMap<URI, URI> kernels;
    private boolean isReady;
    private String hzRegId1;
    private String hzRegId2;
    private NetworkService network;
    private LogService logger;
    private ExecutorService executorService;
    private final ListenerCollection<KernelDiscoveryServiceListener> listeners = new ListenerCollection();
    private HazelcastInstance hazelcastInstance;
    private final HazelcastListener hzListener = new HazelcastListener();
    private NetworkStartListener networkStartListener = new NetworkStartListener();

    @Inject
    public HazelcastKernelDiscoveryService(@Named(value="janus.context.id") UUID janusID) {
        this.janusID = janusID;
    }

    @Override
    public boolean isReadyForOtherServices() {
        return this.isRunning() && this.isReady;
    }

    @Override
    public final Class<? extends Service> getServiceType() {
        return KernelDiscoveryService.class;
    }

    @Override
    public Collection<Class<? extends Service>> getServiceDependencies() {
        return Arrays.asList(LogService.class, ExecutorService.class);
    }

    @Inject
    void postConstruction(HazelcastInstance iHazelcastInstance, NetworkService networkService, ExecutorService iExecutorService, LogService iLogger) {
        this.executorService = iExecutorService;
        this.hazelcastInstance = iHazelcastInstance;
        this.logger = iLogger;
        this.network = networkService;
        this.kernels = iHazelcastInstance.getMap(String.valueOf(this.janusID.toString()) + "-kernels");
        this.network.addListener(this.networkStartListener, this.executorService.getExecutorService());
    }

    @Override
    public URI getCurrentKernel() {
        return this.currentPubURI;
    }

    @Override
    public synchronized Collection<URI> getKernels() {
        return new ArrayList<URI>(this.kernels.values());
    }

    @Override
    public void addKernelDiscoveryServiceListener(KernelDiscoveryServiceListener listener) {
        this.listeners.add(KernelDiscoveryServiceListener.class, listener);
    }

    @Override
    public void removeKernelDiscoveryServiceListener(KernelDiscoveryServiceListener listener) {
        this.listeners.remove(KernelDiscoveryServiceListener.class, listener);
    }

    protected void fireKernelDiscovered(URI uri) {
        this.logger.getKernelLogger().info(MessageFormat.format(Messages.HazelcastKernelDiscoveryService_0, uri, this.getCurrentKernel()));
        KernelDiscoveryServiceListener[] kernelDiscoveryServiceListenerArray = (KernelDiscoveryServiceListener[])this.listeners.getListeners(KernelDiscoveryServiceListener.class);
        int n = kernelDiscoveryServiceListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            KernelDiscoveryServiceListener listener = kernelDiscoveryServiceListenerArray[n2];
            listener.kernelDiscovered(uri);
            ++n2;
        }
    }

    protected void fireKernelDisconnected(URI uri) {
        this.logger.getKernelLogger().info(MessageFormat.format(Messages.HazelcastKernelDiscoveryService_1, uri, this.getCurrentKernel()));
        KernelDiscoveryServiceListener[] kernelDiscoveryServiceListenerArray = (KernelDiscoveryServiceListener[])this.listeners.getListeners(KernelDiscoveryServiceListener.class);
        int n = kernelDiscoveryServiceListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            KernelDiscoveryServiceListener listener = kernelDiscoveryServiceListenerArray[n2];
            listener.kernelDisconnected(uri);
            ++n2;
        }
    }

    @Override
    protected synchronized void doStart() {
        this.hzRegId1 = this.kernels.addEntryListener(this.hzListener, true);
        this.hzRegId2 = this.hazelcastInstance.getCluster().addMembershipListener(this.hzListener);
        this.notifyStarted();
    }

    @Override
    protected synchronized void doStop() {
        this.isReady = false;
        if (this.hzRegId1 != null) {
            this.kernels.removeEntryListener(this.hzRegId1);
        }
        if (this.hzRegId2 != null) {
            this.hazelcastInstance.getClientService().removeClientListener(this.hzRegId2);
        }
        if (this.currentHzURI != null) {
            this.kernels.remove(this.currentHzURI);
        }
        this.network = null;
        this.notifyStopped();
    }

    private class HazelcastListener
    implements MembershipListener,
    EntryAddedListener<URI, URI>,
    EntryRemovedListener<URI, URI>,
    EntryEvictedListener<URI, URI> {
        HazelcastListener() {
        }

        @Override
        public void memberAdded(MembershipEvent membershipEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void memberRemoved(MembershipEvent membershipEvent) {
            URI u;
            InetSocketAddress socketAddress = membershipEvent.getMember().getSocketAddress();
            if (socketAddress != null && (u = NetworkUtil.toURI(socketAddress)) != null) {
                HazelcastKernelDiscoveryService hazelcastKernelDiscoveryService = HazelcastKernelDiscoveryService.this;
                synchronized (hazelcastKernelDiscoveryService) {
                    HazelcastKernelDiscoveryService.this.kernels.remove(u);
                }
            }
        }

        @Override
        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        }

        @Override
        public void entryAdded(EntryEvent<URI, URI> event) {
            URI newPeer = event.getValue();
            assert (newPeer != null);
            if (!newPeer.equals(HazelcastKernelDiscoveryService.this.getCurrentKernel())) {
                HazelcastKernelDiscoveryService.this.fireKernelDiscovered(newPeer);
            }
        }

        @Override
        public void entryRemoved(EntryEvent<URI, URI> event) {
            this.fireDisconnected(event);
        }

        @Override
        public void entryEvicted(EntryEvent<URI, URI> event) {
            this.fireDisconnected(event);
        }

        private void fireDisconnected(EntryEvent<URI, URI> event) {
            URI oldPeer = event.getValue();
            if (oldPeer != null && !oldPeer.equals(HazelcastKernelDiscoveryService.this.getCurrentKernel())) {
                HazelcastKernelDiscoveryService.this.fireKernelDisconnected(oldPeer);
            }
        }
    }

    private class NetworkStartListener
    extends Service.Listener {
        NetworkStartListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void running() {
            URI uri = HazelcastKernelDiscoveryService.this.network.getURI();
            if (HazelcastKernelDiscoveryService.this.currentPubURI == null) {
                HazelcastKernelDiscoveryService hazelcastKernelDiscoveryService = HazelcastKernelDiscoveryService.this;
                synchronized (hazelcastKernelDiscoveryService) {
                    HazelcastKernelDiscoveryService.this.currentPubURI = uri;
                    HazelcastKernelDiscoveryService.this.currentHzURI = NetworkUtil.toURI(HazelcastKernelDiscoveryService.this.hazelcastInstance.getCluster().getLocalMember().getSocketAddress());
                }
                for (URI remotePublicKernel : HazelcastKernelDiscoveryService.this.getKernels()) {
                    HazelcastKernelDiscoveryService.this.fireKernelDiscovered(remotePublicKernel);
                }
                hazelcastKernelDiscoveryService = HazelcastKernelDiscoveryService.this;
                synchronized (hazelcastKernelDiscoveryService) {
                    HazelcastKernelDiscoveryService.this.isReady = true;
                    HazelcastKernelDiscoveryService.this.kernels.putIfAbsent(HazelcastKernelDiscoveryService.this.currentHzURI, HazelcastKernelDiscoveryService.this.currentPubURI);
                }
            }
        }
    }
}

