/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.gson;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import io.janusproject.kernel.services.gson.Messages;
import io.janusproject.services.network.AbstractEventSerializer;
import io.janusproject.services.network.EventDispatch;
import io.janusproject.services.network.EventEncrypter;
import io.janusproject.services.network.EventEnvelope;
import io.janusproject.services.network.NetworkConfig;
import io.janusproject.services.network.NetworkUtil;
import io.janusproject.util.ClassFinder;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Scope;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.core.SpaceSpecification;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Map;
import java.util.UUID;

public class GsonEventSerializer
extends AbstractEventSerializer {
    private static final String X_ENCODING = "x-encoding";
    private static final String X_SPACESPEC_CLASS = "x-java-spacespec-class";
    private static final String X_EVENT_CLASS = "x-java-event-class";
    private static final String X_SCOPE_CLASS = "x-java-scope-class";
    protected final Gson gson;

    @Inject
    public GsonEventSerializer(Gson gson, EventEncrypter encrypter) {
        super(encrypter);
        this.gson = gson;
    }

    @Override
    public EventEnvelope serialize(EventDispatch dispatch) throws Exception {
        assert (this.encrypter != null) : "Invalid injection of the encrypter";
        assert (this.gson != null) : "Invalid injection of Gson";
        assert (dispatch != null) : "Parameter 'dispatch' must not be null";
        Event event = dispatch.getEvent();
        assert (event != null);
        Scope<?> scope = dispatch.getScope();
        assert (scope != null);
        SpaceID spaceID = dispatch.getSpaceID();
        assert (spaceID != null);
        assert (spaceID.getSpaceSpecification() != null);
        Map<String, String> headers = dispatch.getCustomHeaders();
        assert (headers != null);
        Charset encoding = NetworkConfig.getStringEncodingCharset();
        headers.put(X_ENCODING, encoding.name());
        headers.put(X_EVENT_CLASS, event.getClass().getName());
        headers.put(X_SCOPE_CLASS, scope.getClass().getName());
        headers.put(X_SPACESPEC_CLASS, spaceID.getSpaceSpecification().getName());
        byte[] serializedContextID = NetworkUtil.toByteArray(spaceID.getContextID());
        byte[] serializedSpaceID = NetworkUtil.toByteArray(spaceID.getID());
        byte[] serializedHeaders = this.gson.toJson(dispatch.getCustomHeaders()).getBytes(encoding);
        byte[] serializedScope = this.gson.toJson(scope).getBytes(encoding);
        byte[] serializedEvent = this.gson.toJson(event).getBytes(encoding);
        EventEnvelope envelope = new EventEnvelope(serializedContextID, serializedSpaceID, serializedScope, serializedHeaders, serializedEvent);
        this.encrypter.encrypt(envelope);
        return envelope;
    }

    private static Map<String, String> getHeadersFromString(String src) {
        Gson gson = new Gson();
        Type headersType = new TypeToken<Map<String, String>>(){}.getType();
        return (Map)gson.fromJson(src, headersType);
    }

    @Override
    public EventDispatch deserialize(EventEnvelope envelope) throws Exception {
        assert (this.encrypter != null) : "Invalid injection of the encrypter";
        assert (this.gson != null) : "Invalid injection of Gson";
        this.encrypter.decrypt(envelope);
        UUID contextId = NetworkUtil.fromByteArray(envelope.getContextId());
        UUID spaceId = NetworkUtil.fromByteArray(envelope.getSpaceId());
        Map<String, String> headers = GsonEventSerializer.getHeadersFromString(new String(envelope.getCustomHeaders(), NetworkConfig.getStringEncodingCharset()));
        String encodingName = headers.get(X_ENCODING);
        Charset encoding = null;
        if (!Strings.isNullOrEmpty(encodingName)) {
            try {
                encoding = Charset.forName(encodingName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (encoding == null) {
            encoding = NetworkConfig.getStringEncodingCharset();
        }
        Class<SpaceSpecification> spaceSpec = GsonEventSerializer.extractClass(X_SPACESPEC_CLASS, headers, SpaceSpecification.class);
        Class<Event> eventClazz = GsonEventSerializer.extractClass(X_EVENT_CLASS, headers, Event.class);
        Class<Scope> scopeClazz = GsonEventSerializer.extractClass(X_SCOPE_CLASS, headers, Scope.class);
        SpaceID spaceID = new SpaceID(contextId, spaceId, spaceSpec);
        Event event = this.gson.fromJson(new String(envelope.getBody(), encoding), eventClazz);
        assert (event != null);
        Scope scope = this.gson.fromJson(new String(envelope.getScope(), encoding), scopeClazz);
        assert (scope != null);
        return new EventDispatch(spaceID, event, scope, headers);
    }

    private static <T> Class<? extends T> extractClass(String key, Map<String, String> headers, Class<T> expectedType) {
        assert (key != null);
        assert (headers != null);
        String classname = headers.get(key);
        Class<?> type = null;
        if (classname != null) {
            type = ClassFinder.findClass(classname);
        }
        if (type == null) {
            throw new RuntimeException(new ClassNotFoundException(MessageFormat.format(Messages.GsonEventSerializer_0, classname)));
        }
        if (!expectedType.isAssignableFrom(type)) {
            throw new ClassCastException(MessageFormat.format(Messages.GsonEventSerializer_1, classname, expectedType.getName()));
        }
        assert (type != null);
        return type.asSubclass(expectedType);
    }

    public static class ClassTypeAdapter
    implements JsonSerializer<Class<?>>,
    JsonDeserializer<Class<?>> {
        @Override
        public JsonElement serialize(Class<?> src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.getName());
        }

        @Override
        public Class<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String className = json.getAsString();
            Class<?> type = ClassFinder.findClass(className);
            if (type == null) {
                throw new JsonParseException(new ClassNotFoundException(className));
            }
            return type;
        }
    }
}

