/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.repository;

import com.google.inject.Provider;
import io.janusproject.kernel.repository.ParticipantRepository;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.util.concurrent.Collections3;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class UniqueAddressParticipantRepository<ADDRESST extends Serializable>
extends ParticipantRepository<ADDRESST> {
    private final Map<UUID, ADDRESST> participants;
    private final ReadWriteLock participantsLock;
    private final String distributedParticipantMapName;

    public UniqueAddressParticipantRepository(String distributedParticipantMapName, DistributedDataStructureService repositoryImplFactory, Provider<ReadWriteLock> lockProvider) {
        this.participantsLock = lockProvider.get();
        this.distributedParticipantMapName = distributedParticipantMapName;
        this.participants = repositoryImplFactory.getMap(this.distributedParticipantMapName, null);
    }

    @Override
    @Pure
    public ReadWriteLock getLock() {
        return this.participantsLock;
    }

    public ADDRESST registerParticipant(ADDRESST address, EventListener entity) {
        ReadWriteLock lock = this.getLock();
        lock.writeLock().lock();
        try {
            this.addListener(address, entity);
            this.participants.put(entity.getID(), address);
        }
        finally {
            lock.writeLock().unlock();
        }
        return address;
    }

    @Inline(value="unregisterParticipant(($1).getID())")
    public ADDRESST unregisterParticipant(EventListener entity) {
        return this.unregisterParticipant(entity.getID());
    }

    public ADDRESST unregisterParticipant(UUID entityID) {
        Serializable adr = null;
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            adr = (Serializable)this.participants.get(entityID);
        }
        finally {
            lock.readLock().unlock();
        }
        if (adr != null) {
            lock.writeLock().lock();
            try {
                this.removeListener(adr);
                this.participants.remove(entityID);
            }
            finally {
                lock.writeLock().unlock();
            }
        }
        return (ADDRESST)adr;
    }

    @Pure
    @Inline(value="getAddress(($1).getID())")
    public ADDRESST getAddress(EventListener entity) {
        return this.getAddress(entity.getID());
    }

    @Pure
    public ADDRESST getAddress(UUID id) {
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            Serializable serializable = (Serializable)this.participants.get(id);
            return (ADDRESST)serializable;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Pure
    public SynchronizedCollection<ADDRESST> getParticipantAddresses() {
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            SynchronizedCollection<ADDRESST> synchronizedCollection = Collections3.synchronizedCollection(this.participants.values(), lock);
            return synchronizedCollection;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Pure
    public SynchronizedSet<UUID> getParticipantIDs() {
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            SynchronizedSet<UUID> synchronizedSet = Collections3.synchronizedSet(this.participants.keySet(), lock);
            return synchronizedSet;
        }
        finally {
            lock.readLock().unlock();
        }
    }
}

