/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.repository;

import io.sarl.lang.core.EventListener;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.util.concurrent.Collections3;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import org.eclipse.xtext.xbase.lib.Pure;

public abstract class ParticipantRepository<ADDRESST extends Serializable> {
    private final Map<ADDRESST, EventListener> participants = new TreeMap<ADDRESST, EventListener>();

    protected ParticipantRepository() {
    }

    @Pure
    public int listenerCount() {
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            int n = this.participants.size();
            return n;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    protected boolean isListenerEmpty() {
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            boolean bl = this.participants.isEmpty();
            return bl;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    protected boolean containsAddress(ADDRESST key) {
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            boolean bl = this.participants.containsKey(key);
            return bl;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    protected boolean containsListener(EventListener value) {
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            boolean bl = this.participants.containsValue(value);
            return bl;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    protected EventListener getListener(ADDRESST key) {
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            EventListener eventListener = this.participants.get(key);
            return eventListener;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    protected EventListener addListener(ADDRESST key, EventListener value) {
        ReadWriteLock lock = this.getLock();
        lock.writeLock().lock();
        try {
            EventListener eventListener = this.participants.put(key, value);
            return eventListener;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    protected EventListener removeListener(ADDRESST key) {
        ReadWriteLock lock = this.getLock();
        lock.writeLock().lock();
        try {
            EventListener eventListener = this.participants.remove(key);
            return eventListener;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    protected void clearListeners() {
        ReadWriteLock lock = this.getLock();
        lock.writeLock().lock();
        try {
            this.participants.clear();
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    protected SynchronizedSet<ADDRESST> getAdresses() {
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            SynchronizedSet<ADDRESST> synchronizedSet = Collections3.synchronizedSet(this.participants.keySet(), lock);
            return synchronizedSet;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public SynchronizedCollection<EventListener> getListeners() {
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            SynchronizedCollection<EventListener> synchronizedCollection = Collections3.synchronizedCollection(this.participants.values(), lock);
            return synchronizedCollection;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    protected Set<Map.Entry<ADDRESST, EventListener>> listenersEntrySet() {
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            SynchronizedSet<Map.Entry<ADDRESST, EventListener>> synchronizedSet = Collections3.synchronizedSet(this.participants.entrySet(), lock);
            return synchronizedSet;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Pure
    public abstract ReadWriteLock getLock();
}

