/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.repository;

import com.google.inject.Provider;
import io.janusproject.kernel.repository.ParticipantRepository;
import io.janusproject.services.distributeddata.DMultiMap;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.util.concurrent.Collections3;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;

public final class MultipleAddressParticipantRepository<ADDRESST extends Serializable>
extends ParticipantRepository<ADDRESST> {
    private final DMultiMap<UUID, ADDRESST> participants;
    private final ReadWriteLock participantsLock;
    private final String distributedParticipantMapName;

    public MultipleAddressParticipantRepository(String distributedParticipantMapName, DistributedDataStructureService repositoryImplFactory, Provider<ReadWriteLock> lockProvider) {
        this.participantsLock = lockProvider.get();
        this.distributedParticipantMapName = distributedParticipantMapName;
        this.participants = repositoryImplFactory.getMultiMap(this.distributedParticipantMapName, null);
    }

    @Override
    public ReadWriteLock getLock() {
        return this.participantsLock;
    }

    public ADDRESST registerParticipant(ADDRESST address, EventListener entity) {
        ReadWriteLock lock = this.getLock();
        lock.writeLock().lock();
        try {
            this.addListener(address, entity);
            this.participants.put(entity.getID(), address);
        }
        finally {
            lock.writeLock().unlock();
        }
        return address;
    }

    public ADDRESST unregisterParticipant(ADDRESST address, EventListener entity) {
        ReadWriteLock lock = this.getLock();
        lock.writeLock().lock();
        try {
            this.removeListener(address);
            this.participants.remove(entity.getID(), address);
        }
        finally {
            lock.writeLock().unlock();
        }
        return address;
    }

    public SynchronizedCollection<ADDRESST> getAddresses(UUID participant) {
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            SynchronizedCollection synchronizedCollection = Collections3.synchronizedCollection(this.participants.get(participant), lock);
            return synchronizedCollection;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public SynchronizedCollection<ADDRESST> getParticipantAddresses() {
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            SynchronizedCollection synchronizedCollection = Collections3.synchronizedCollection(this.participants.values(), lock);
            return synchronizedCollection;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public SynchronizedSet<UUID> getParticipantIDs() {
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            SynchronizedSet<UUID> synchronizedSet = Collections3.synchronizedSet(this.participants.keySet(), lock);
            return synchronizedSet;
        }
        finally {
            lock.readLock().unlock();
        }
    }
}

