/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.janusproject.kernel.bic.AgentTraitData;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.Messages;
import io.janusproject.services.executor.EarlyExitException;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.executor.JanusRunnable;
import io.sarl.core.AgentTask;
import io.sarl.core.Logging;
import io.sarl.core.Schedules;
import io.sarl.core.Time;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Behavior;
import io.sarl.lang.core.Capacities;
import io.sarl.lang.core.SREutils;
import io.sarl.lang.core.Skill;
import io.sarl.lang.util.ClearableReference;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.util.concurrent.Collections3;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class SchedulesSkill
extends BuiltinSkill
implements Schedules {
    private static int installationOrder = -1;
    @Inject
    private ExecutorService executorService;
    private final Map<String, TaskDescription> tasks = new TreeMap<String, TaskDescription>();
    @Inject
    private ReadWriteLock tasksLock;
    private ClearableReference<Skill> skillBufferLogging;
    private ClearableReference<Skill> skillBufferTime;

    SchedulesSkill(Agent agent) {
        super(agent);
    }

    protected final Logging getLoggingSkill() {
        if (this.skillBufferLogging == null || this.skillBufferLogging.get() == null) {
            this.skillBufferLogging = this.$getSkill(Logging.class);
        }
        return this.$castSkill(Logging.class, this.skillBufferLogging);
    }

    protected final Time getTimeSkill() {
        if (this.skillBufferTime == null || this.skillBufferTime.get() == null) {
            this.skillBufferTime = this.$getSkill(Time.class);
        }
        return this.$castSkill(Time.class, this.skillBufferTime);
    }

    @Override
    @Deprecated
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = SchedulesSkill.installationOrder(this);
        }
        return installationOrder;
    }

    protected final ReadWriteLock getTaskListLock() {
        return this.tasksLock;
    }

    @Override
    @Pure
    public void toString(ToStringBuilder builder) {
        super.toString(builder);
        builder.add("tasks", this.tasks);
    }

    private void finishTask(AgentTask task, boolean updateSkillReferences, boolean updateAgentTraitReferences) {
        AgentTrait trait;
        AgentTraitData data;
        Object initiator;
        assert (task != null);
        if (updateSkillReferences) {
            ReadWriteLock llock = this.getTaskListLock();
            llock.writeLock().lock();
            try {
                this.tasks.remove(task.getName());
            }
            finally {
                llock.writeLock().unlock();
            }
        }
        if (updateAgentTraitReferences && (initiator = task.getInitiator()) instanceof AgentTrait && (data = SREutils.getSreSpecificData(trait = (AgentTrait)initiator, AgentTraitData.class)) != null) {
            data.removeTask(task);
        }
    }

    @Override
    public SynchronizedSet<String> getActiveTasks() {
        ReadWriteLock lock = this.getTaskListLock();
        lock.readLock().lock();
        try {
            SynchronizedSet<String> synchronizedSet = Collections3.unmodifiableSynchronizedSet(this.tasks.keySet(), lock);
            return synchronizedSet;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    Collection<Future<?>> getActiveFutures() {
        ReadWriteLock lock = this.getTaskListLock();
        lock.readLock().lock();
        try {
            ArrayList<Future<?>> arrayList = Lists.newArrayList(Iterables.transform(this.tasks.values(), it -> it.getFuture()));
            return arrayList;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    void unregisterTasksForBehavior(Behavior behavior) {
        AgentTraitData data = SREutils.getSreSpecificData(behavior, AgentTraitData.class);
        if (data != null) {
            Iterable<AgentTask> iterable = data.resetTaskList();
            for (AgentTask taskToCancel : iterable) {
                this.cancel(taskToCancel, true, false);
            }
        }
    }

    private void cancelAllRunningTasks() {
        ReadWriteLock lock = this.getTaskListLock();
        lock.writeLock().lock();
        try {
            for (Map.Entry<String, TaskDescription> taskDescription : this.tasks.entrySet()) {
                AgentTask task;
                TaskDescription pair = taskDescription.getValue();
                if (pair == null) continue;
                Future<?> future = pair.getFuture();
                if (future != null) {
                    future.cancel(true);
                }
                if ((task = pair.getTask()) == null) continue;
                this.finishTask(task, false, true);
            }
            this.tasks.clear();
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    protected void uninstall(Skill.UninstallationStage stage) {
        if (stage == Skill.UninstallationStage.PRE_DESTROY_EVENT) {
            this.cancelAllRunningTasks();
        } else {
            this.cancelAllRunningTasks();
        }
    }

    @Override
    public AgentTask in(long delay, Procedures.Procedure1<? super Agent> procedure) {
        return this.in(Schedules.$DEFAULT_VALUE$IN_0, delay, procedure);
    }

    @Override
    public AgentTask in(AgentTask task, long delay, Procedures.Procedure1<? super Agent> procedure) {
        TaskDescription description = this.preRunTask(task, procedure);
        long osDelay = Math.round(this.getTimeSkill().toOSDuration(delay));
        AgentTask runnableTask = description != null ? description.getTask() : task;
        ScheduledFuture<?> sf = this.executorService.schedule(new AgentTaskRunner(runnableTask, false), osDelay, TimeUnit.MILLISECONDS);
        description = this.postRunTask(description, task, sf);
        return description.getTask();
    }

    @Override
    public AgentTask at(AgentTask task, long time, Procedures.Procedure1<? super Agent> procedure) {
        long delay = Math.round((double)time - this.getTimeSkill().getTime());
        if ((double)delay > 0.0) {
            return this.in(task, delay, procedure);
        }
        return task;
    }

    private TaskDescription preRunTask(AgentTask task, Procedures.Procedure1<? super Agent> procedure) {
        AgentTask rtask;
        TaskDescription pair;
        if (task == null) {
            pair = this.createTaskIfNecessary(null);
            rtask = pair.getTask();
        } else {
            rtask = task;
            ReadWriteLock lock = this.getTaskListLock();
            lock.readLock().lock();
            try {
                pair = this.tasks.get(task.getName());
            }
            finally {
                lock.readLock().unlock();
            }
            if (pair != null) {
                lock.writeLock().lock();
                try {
                    pair.setTask(rtask);
                }
                finally {
                    lock.writeLock().unlock();
                }
            }
        }
        rtask.setProcedure(procedure);
        return pair;
    }

    private TaskDescription postRunTask(TaskDescription description, AgentTask task, Future<?> future) {
        TaskDescription pair;
        if (description == null) {
            pair = new TaskDescription(task, future);
            ReadWriteLock lock = this.getTaskListLock();
            lock.writeLock().lock();
            try {
                this.tasks.put(task.getName(), pair);
            }
            finally {
                lock.writeLock().unlock();
            }
        } else {
            pair = description;
            pair.setFuture(future);
        }
        return pair;
    }

    private TaskDescription createTaskIfNecessary(String name) {
        String realName;
        TaskDescription pair = null;
        ReadWriteLock lock = this.getTaskListLock();
        if (Strings.isNullOrEmpty(name)) {
            realName = "task-" + UUID.randomUUID().toString();
        } else {
            realName = name;
            lock.readLock().lock();
            try {
                pair = this.tasks.get(realName);
            }
            finally {
                lock.readLock().unlock();
            }
        }
        if (pair == null) {
            AgentTrait caller = Capacities.getCaller();
            AgentTask task = new AgentTask(caller);
            task.setTaskName(realName);
            task.setGuard(AgentTask.TRUE_GUARD);
            pair = new TaskDescription(task);
            lock.writeLock().lock();
            try {
                this.tasks.put(realName, pair);
            }
            finally {
                lock.writeLock().unlock();
            }
            if (caller != null) {
                AgentTraitData data = SREutils.getSreSpecificData(caller, AgentTraitData.class);
                if (data == null) {
                    data = new AgentTraitData();
                    SREutils.setSreSpecificData(caller, data);
                }
                data.addTask(task);
            }
        }
        return pair;
    }

    @Override
    public AgentTask task(String name) {
        return this.createTaskIfNecessary(name).getTask();
    }

    @Override
    public void setName(AgentTask task, String name) {
        TaskDescription desc;
        String nm = name;
        int i = 0;
        String prefix = String.valueOf(name) + "-";
        ReadWriteLock lock = this.getTaskListLock();
        lock.writeLock().lock();
        try {
            desc = this.tasks.remove(task.getName());
            if (desc != null) {
                lock.readLock().lock();
            }
        }
        finally {
            lock.writeLock().unlock();
        }
        if (desc != null) {
            try {
                while (this.tasks.containsKey(nm)) {
                    nm = String.valueOf(prefix) + ++i;
                }
            }
            finally {
                lock.readLock().unlock();
            }
            task.setTaskName(nm);
            lock.writeLock().lock();
            try {
                this.tasks.put(nm, desc);
            }
            finally {
                lock.writeLock().unlock();
            }
        }
    }

    @Override
    public final boolean cancel(AgentTask task) {
        return this.cancel(task, true, true);
    }

    @Override
    public final boolean cancel(AgentTask task, boolean mayInterruptIfRunning) {
        return this.cancel(task, mayInterruptIfRunning, true);
    }

    protected boolean cancel(AgentTask task, boolean mayInterruptIfRunning, boolean updateAgentTraitReferences) {
        if (task != null) {
            Future<?> future;
            TaskDescription pair;
            String name = task.getName();
            ReadWriteLock lock = this.getTaskListLock();
            lock.readLock().lock();
            try {
                pair = this.tasks.get(name);
            }
            finally {
                lock.readLock().unlock();
            }
            if (pair != null && (future = pair.getFuture()) != null && !future.isDone() && !future.isCancelled() && future.cancel(mayInterruptIfRunning)) {
                this.finishTask(task, true, updateAgentTraitReferences);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCanceled(AgentTask task) {
        String name;
        Future<?> future;
        if (task != null && (future = this.getActiveFuture(name = task.getName())) != null) {
            return future.isCancelled();
        }
        return false;
    }

    Future<?> getActiveFuture(String taskName) {
        TaskDescription pair;
        ReadWriteLock lock = this.getTaskListLock();
        lock.readLock().lock();
        try {
            pair = this.tasks.get(taskName);
        }
        finally {
            lock.readLock().unlock();
        }
        if (pair != null) {
            return pair.getFuture();
        }
        return null;
    }

    @Override
    public AgentTask every(long period, Procedures.Procedure1<? super Agent> procedure) {
        return this.every(Schedules.$DEFAULT_VALUE$EVERY_0, period, procedure);
    }

    @Override
    public AgentTask every(AgentTask task, long period, Procedures.Procedure1<? super Agent> procedure) {
        TaskDescription description = this.preRunTask(task, procedure);
        long osPeriod = Math.round(this.getTimeSkill().toOSDuration(period));
        AgentTask runnableTask = description != null ? description.getTask() : task;
        ScheduledFuture<?> sf = this.executorService.scheduleAtFixedRate(new AgentTaskRunner(runnableTask, true), 0L, osPeriod, TimeUnit.MILLISECONDS);
        description = this.postRunTask(description, task, sf);
        return description.getTask();
    }

    @Override
    public AgentTask atFixedDelay(long delay, Procedures.Procedure1<? super Agent> procedure) {
        return this.atFixedDelay(Schedules.$DEFAULT_VALUE$ATFIXEDDELAY_0, delay, procedure);
    }

    @Override
    public AgentTask atFixedDelay(AgentTask task, long delay, Procedures.Procedure1<? super Agent> procedure) {
        TaskDescription description = this.preRunTask(task, procedure);
        AgentTask runnableTask = description != null ? description.getTask() : task;
        long osDelay = Math.round(this.getTimeSkill().toOSDuration(delay));
        Future<?> future = osDelay <= 0L ? this.executorService.submit(new AgentInfiniteLoopTask(runnableTask)) : this.executorService.scheduleWithFixedDelay(new AgentTaskRunner(runnableTask, true), 0L, osDelay, TimeUnit.MILLISECONDS);
        description = this.postRunTask(description, task, future);
        return description.getTask();
    }

    @Override
    public AgentTask execute(Procedures.Procedure1<? super Agent> procedure) {
        return this.execute(Schedules.$DEFAULT_VALUE$EXECUTE_0, procedure);
    }

    @Override
    public AgentTask execute(AgentTask task, Procedures.Procedure1<? super Agent> procedure) {
        TaskDescription description = this.preRunTask(task, procedure);
        AgentTask runnableTask = description != null ? description.getTask() : task;
        Future<?> future = this.executorService.submit(new AgentTaskRunner(runnableTask, false));
        description = this.postRunTask(description, task, future);
        return description.getTask();
    }

    private class AgentInfiniteLoopTask
    extends JanusRunnable {
        private WeakReference<AgentTask> agentTaskRef;

        AgentInfiniteLoopTask(AgentTask task) {
            this.agentTaskRef = new WeakReference<AgentTask>(task);
        }

        private boolean canRun() {
            AgentTask task = (AgentTask)this.agentTaskRef.get();
            if (task != null) {
                Future<?> future = SchedulesSkill.this.getActiveFuture(task.getName());
                return future != null && !future.isDone() && !future.isCancelled();
            }
            return false;
        }

        private Functions.Function1<? super Agent, ? extends Boolean> getGuard() {
            AgentTask task = (AgentTask)this.agentTaskRef.get();
            if (task != null) {
                return task.getGuard();
            }
            return null;
        }

        private Procedures.Procedure1<? super Agent> getProcedure() {
            AgentTask task = (AgentTask)this.agentTaskRef.get();
            if (task != null) {
                return task.getProcedure();
            }
            return null;
        }

        @Override
        public void run() {
            try {
                try {
                    Agent owner = SchedulesSkill.this.getOwner();
                    while (this.canRun()) {
                        Functions.Function1<? super Agent, ? extends Boolean> guard = this.getGuard();
                        if (guard == null || guard.apply(owner).booleanValue()) {
                            Procedures.Procedure1<? super Agent> procedure = this.getProcedure();
                            if (procedure != null) {
                                procedure.apply(owner);
                            }
                            Thread.yield();
                            continue;
                        }
                        break;
                    }
                }
                catch (EarlyExitException owner) {
                    AgentTask task = (AgentTask)this.agentTaskRef.get();
                    if (task != null) {
                        SchedulesSkill.this.finishTask(task, true, true);
                    }
                }
                catch (Throwable ex) {
                    SchedulesSkill.this.getLoggingSkill().error((Object)Messages.SchedulesSkill_1, ex, this.toString(), ex.getLocalizedMessage());
                    AgentTask task = (AgentTask)this.agentTaskRef.get();
                    if (task != null) {
                        SchedulesSkill.this.finishTask(task, true, true);
                    }
                }
            }
            finally {
                AgentTask task = (AgentTask)this.agentTaskRef.get();
                if (task != null) {
                    SchedulesSkill.this.finishTask(task, true, true);
                }
            }
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).add("name", ((AgentTask)this.agentTaskRef.get()).getName()).add("agent", SchedulesSkill.this.getOwner().getID()).toString();
        }
    }

    private class AgentTaskRunner
    extends JanusRunnable {
        private final WeakReference<AgentTask> agentTaskRef;
        private WeakReference<Future<?>> future;
        private final boolean isPeriodic;

        AgentTaskRunner(AgentTask task, boolean isPeriodic) {
            assert (task != null);
            this.agentTaskRef = new WeakReference<AgentTask>(task);
            this.isPeriodic = isPeriodic;
        }

        void setFuture(Future<?> future) {
            this.future = future == null ? null : new WeakReference(future);
        }

        private Future<?> getFuture() {
            WeakReference<Future<?>> safeFutureReference = this.future;
            return safeFutureReference == null ? null : (Future)safeFutureReference.get();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            AgentTask task = (AgentTask)this.agentTaskRef.get();
            if (task == null) {
                throw new RuntimeException(Messages.SchedulesSkill_0);
            }
            Future<?> future = this.getFuture();
            if (future != null && (future.isDone() || future.isCancelled())) {
                this.setFuture(null);
                return;
            }
            boolean mustBeCanceled = false;
            try {
                try {
                    Agent owner = SchedulesSkill.this.getOwner();
                    Functions.Function1<? super Agent, ? extends Boolean> guard = task.getGuard();
                    if (guard == null || guard.apply(owner).booleanValue()) {
                        Procedures.Procedure1<? super Agent> procedure = task.getProcedure();
                        if (procedure == null) return;
                        procedure.apply(owner);
                        return;
                    } else {
                        mustBeCanceled = true;
                    }
                    return;
                }
                catch (EarlyExitException owner) {
                    if (!mustBeCanceled && this.isPeriodic) return;
                    SchedulesSkill.this.finishTask(task, true, true);
                    return;
                }
                catch (Throwable ex) {
                    SchedulesSkill.this.getLoggingSkill().error((Object)Messages.SchedulesSkill_1, ex, this.toString(), ex.getLocalizedMessage());
                    mustBeCanceled = true;
                    if (!mustBeCanceled && this.isPeriodic) return;
                    SchedulesSkill.this.finishTask(task, true, true);
                    return;
                }
            }
            finally {
                if (mustBeCanceled || !this.isPeriodic) {
                    SchedulesSkill.this.finishTask(task, true, true);
                }
            }
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).add("name", ((AgentTask)this.agentTaskRef.get()).getName()).add("agent", SchedulesSkill.this.getOwner().getID()).toString();
        }
    }

    private static class TaskDescription {
        private AgentTask task;
        private Future<?> future;

        TaskDescription(AgentTask task) {
            this(task, null);
        }

        TaskDescription(AgentTask task, Future<?> future) {
            this.task = task;
            this.future = future == null ? new FutureReceiver() : future;
        }

        public String toString() {
            return Objects.toString(this.task);
        }

        public AgentTask getTask() {
            return this.task;
        }

        public void setTask(AgentTask task) {
            this.task = task;
        }

        public Future<?> getFuture() {
            return this.future;
        }

        public void setFuture(Future<?> future) {
            if (future != null) {
                FutureReceiver receiver = this.future instanceof FutureReceiver ? (FutureReceiver)this.future : null;
                this.future = future;
                if (receiver != null) {
                    receiver.apply(this.future);
                }
            }
        }

        private static class FutureReceiver
        implements Future<Object> {
            private final AtomicBoolean cancelFlag = new AtomicBoolean();
            private final AtomicBoolean mayInterruptIfRunningFlag = new AtomicBoolean();

            FutureReceiver() {
            }

            void apply(Future<?> future) {
                if (future != null && !future.isCancelled() && !future.isDone() && this.cancelFlag.get()) {
                    future.cancel(this.mayInterruptIfRunningFlag.get());
                }
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                this.mayInterruptIfRunningFlag.set(mayInterruptIfRunning);
                this.cancelFlag.set(true);
                return true;
            }

            @Override
            public boolean isCancelled() {
                return this.cancelFlag.get();
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public Object get() throws InterruptedException, ExecutionException {
                throw new ExecutionException(new UnsupportedOperationException());
            }

            @Override
            public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                throw new ExecutionException(new UnsupportedOperationException());
            }
        }
    }
}

