/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.Messages;
import io.janusproject.services.logging.LogService;
import io.janusproject.util.LoggerCreator;
import io.sarl.core.Logging;
import io.sarl.lang.core.Agent;
import java.text.MessageFormat;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggingSkill
extends BuiltinSkill
implements Logging {
    private static final Level DEBUG_LEVEL = Level.FINE;
    private static final Level INFO_LEVEL = Level.INFO;
    private static final Level WARNING_LEVEL = Level.WARNING;
    private static final Level ERROR_LEVEL = Level.SEVERE;
    private static int installationOrder = -1;
    private LogService logService;
    private Logger logger;

    LoggingSkill(Agent agent) {
        super(agent);
    }

    @Override
    @Deprecated
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = LoggingSkill.installationOrder(this);
        }
        return installationOrder;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Inject
    public void setLoggingService(LogService service) {
        assert (service != null);
        this.logService = service;
    }

    public void setLogger(Logger logger) {
        assert (logger != null);
        this.logger = logger;
    }

    @Override
    protected void install() {
        UUID agentId = this.getOwner().getID();
        String loggerName = MessageFormat.format(Messages.LoggingSkill_0, agentId);
        Logger logger = this.logService.createAgentLogger(loggerName);
        this.setLogger(logger);
    }

    @Override
    public void setLoggingName(String name) {
        Logger logger;
        String loggerName = name;
        if (loggerName == null || loggerName.isEmpty()) {
            loggerName = MessageFormat.format(Messages.LoggingSkill_0, this.getOwner().getID());
        }
        Level level = (logger = this.getLogger()) != null ? logger.getLevel() : null;
        logger = this.logService.createAgentLogger(loggerName, level);
        this.setLogger(logger);
    }

    @Override
    public void println(Object message) {
        this.info(message, new Object[0]);
    }

    @Override
    public void error(Object message, Throwable exception, Object ... parameters) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(ERROR_LEVEL) && message != null) {
            String loggeableMessage = message.toString();
            if (exception != null) {
                LogRecord lr = new LogRecord(ERROR_LEVEL, loggeableMessage);
                lr.setParameters(parameters);
                lr.setThrown(Throwables.getRootCause(exception));
                logger.log(lr);
            } else {
                logger.log(ERROR_LEVEL, loggeableMessage, parameters);
            }
        }
    }

    @Override
    public void error(Object message, Object ... parameters) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(ERROR_LEVEL) && message != null) {
            String loggeableMessage = message.toString();
            logger.log(ERROR_LEVEL, loggeableMessage, parameters);
        }
    }

    @Override
    public void error(Supplier<String> messageProvider) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(ERROR_LEVEL) && messageProvider != null) {
            logger.log(ERROR_LEVEL, messageProvider);
        }
    }

    @Override
    public void warning(Object message, Throwable exception, Object ... parameters) {
        String loggeableMessage;
        Logger logger = this.getLogger();
        if (logger.isLoggable(WARNING_LEVEL) && message != null && !(loggeableMessage = message.toString()).isEmpty()) {
            if (exception != null) {
                LogRecord lr = new LogRecord(WARNING_LEVEL, loggeableMessage);
                lr.setParameters(parameters);
                lr.setThrown(exception);
                logger.log(lr);
            } else {
                logger.log(WARNING_LEVEL, loggeableMessage, parameters);
            }
        }
    }

    @Override
    public void warning(Object message, Object ... parameters) {
        String loggeableMessage;
        Logger logger = this.getLogger();
        if (logger.isLoggable(WARNING_LEVEL) && message != null && !(loggeableMessage = message.toString()).isEmpty()) {
            logger.log(WARNING_LEVEL, loggeableMessage, parameters);
        }
    }

    @Override
    public void warning(Supplier<String> messageProvider) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(WARNING_LEVEL) && messageProvider != null) {
            logger.log(WARNING_LEVEL, messageProvider);
        }
    }

    @Override
    public void info(Object message, Object ... parameters) {
        String loggeableMessage;
        Logger logger = this.getLogger();
        if (logger.isLoggable(INFO_LEVEL) && message != null && !(loggeableMessage = message.toString()).isEmpty()) {
            logger.log(INFO_LEVEL, loggeableMessage, parameters);
        }
    }

    @Override
    public void info(Supplier<String> messageProvider) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(INFO_LEVEL) && messageProvider != null) {
            logger.log(INFO_LEVEL, messageProvider);
        }
    }

    @Override
    public void debug(Object message, Object ... parameters) {
        String loggeableMessage;
        Logger logger = this.getLogger();
        if (logger.isLoggable(DEBUG_LEVEL) && message != null && !(loggeableMessage = message.toString()).isEmpty()) {
            logger.log(DEBUG_LEVEL, loggeableMessage, parameters);
        }
    }

    @Override
    public void debug(Supplier<String> messageProvider) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(DEBUG_LEVEL) && messageProvider != null) {
            logger.log(DEBUG_LEVEL, messageProvider);
        }
    }

    @Override
    public boolean isErrorLogEnabled() {
        return this.getLogger().isLoggable(ERROR_LEVEL);
    }

    @Override
    public boolean isWarningLogEnabled() {
        return this.getLogger().isLoggable(WARNING_LEVEL);
    }

    @Override
    public boolean isInfoLogEnabled() {
        return this.getLogger().isLoggable(INFO_LEVEL);
    }

    @Override
    public boolean isDebugLogEnabled() {
        return this.getLogger().isLoggable(DEBUG_LEVEL);
    }

    @Override
    public int getLogLevel() {
        return LoggerCreator.toInt(this.getLogger().getLevel());
    }

    @Override
    public void setLogLevel(int level) {
        Level lvl = LoggerCreator.fromInt(level);
        this.getLogger().setLevel(lvl);
    }
}

