/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.inject.Inject;
import io.janusproject.kernel.bic.AsynchronousAgentKillingEvent;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.spawn.SpawnService;
import io.sarl.core.DefaultContextInteractions;
import io.sarl.core.Lifecycle;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.Skill;
import io.sarl.lang.util.ClearableReference;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class LifecycleSkill
extends BuiltinSkill
implements Lifecycle {
    private static int installationOrder = -1;
    @Inject
    private SpawnService spawnService;
    private ClearableReference<Skill> skillBufferInternalEventBusCapacity;
    private ClearableReference<Skill> skillDefaultContextInteraction;

    LifecycleSkill(Agent agent) {
        super(agent);
    }

    protected final InternalEventBusCapacity getInternalEventBusCapacitySkill() {
        if (this.skillBufferInternalEventBusCapacity == null || this.skillBufferInternalEventBusCapacity.get() == null) {
            this.skillBufferInternalEventBusCapacity = this.$getSkill(InternalEventBusCapacity.class);
        }
        return this.$castSkill(InternalEventBusCapacity.class, this.skillBufferInternalEventBusCapacity);
    }

    protected final DefaultContextInteractions getDefaultContextInteractionsSkill() {
        if (this.skillDefaultContextInteraction == null || this.skillDefaultContextInteraction.get() == null) {
            this.skillDefaultContextInteraction = this.$getSkill(DefaultContextInteractions.class);
        }
        return this.$castSkill(DefaultContextInteractions.class, this.skillDefaultContextInteraction);
    }

    @Override
    @Deprecated
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = LifecycleSkill.installationOrder(this);
        }
        return installationOrder;
    }

    @Override
    public UUID spawn(Class<? extends Agent> agentType, Object ... params) {
        List<UUID> ids = this.spawnService.spawn(1, this.getOwner().getID(), this.getDefaultContextInteractionsSkill().getDefaultContext(), null, agentType, params);
        if (ids.isEmpty()) {
            return null;
        }
        return ids.get(0);
    }

    public Collection<UUID> spawn(int nbAgents, Class<? extends Agent> agentType, Object ... params) {
        return this.spawnService.spawn(nbAgents, this.getOwner().getID(), this.getDefaultContextInteractionsSkill().getDefaultContext(), null, agentType, params);
    }

    @Override
    public UUID spawnInContext(Class<? extends Agent> agentType, AgentContext context, Object ... params) {
        List<UUID> ids = this.spawnService.spawn(1, this.getOwner().getID(), context, null, agentType, params);
        if (ids.isEmpty()) {
            return null;
        }
        return ids.get(0);
    }

    public Collection<UUID> spawnInContext(int nbAgents, Class<? extends Agent> agentClass, AgentContext context, Object ... params) {
        return this.spawnService.spawn(nbAgents, this.getOwner().getID(), context, null, agentClass, params);
    }

    @Override
    public UUID spawnInContextWithID(Class<? extends Agent> agentClass, UUID agentID, AgentContext context, Object ... params) {
        List<UUID> ids = this.spawnService.spawn(1, this.getOwner().getID(), context, agentID, agentClass, params);
        if (ids.isEmpty()) {
            return null;
        }
        return ids.get(0);
    }

    @Override
    public void killMe() {
        InternalEventBusCapacity busCapacity = this.getInternalEventBusCapacitySkill();
        busCapacity.selfEvent(new AsynchronousAgentKillingEvent());
        Thread.yield();
        ExecutorService.neverReturn();
    }
}

